// Copyright (c) 2012 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _TX_FES_SETUP_H_
#define _TX_FES_SETUP_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	schedule_id[15:0], schedule_cmd_ring_id[20:16], fes_control_mode[22:21], number_of_users[24:23], schedule_tries[28:25], msdu_link_ext_endianness[29], send_ndp[30], reserved_0a[31]
//	1	fc_to_ds_mask[0], fc_from_ds_mask[1], fc_more_frag_mask[2], fc_retry_mask[3], fc_pwr_mgt_mask[4], fc_more_data_mask[5], fc_prot_frame_mask[6], fc_order_mask[7], duration_field_mask[8], sequence_control_mask[9], qc_tid_mask[10], qc_eosp_mask[11], qc_ack_policy_mask[12], qc_amsdu_mask[13], reserved_1[14], qc_15to8_mask[15], iv_mask[16], fc_to_ds_setting[17], fc_from_ds_setting[18], fc_more_frag_setting[19], fc_retry_setting[21:20], fc_pwr_mgt_setting[22], fc_more_data_setting[24:23], fc_prot_frame_setting[26:25], fc_order_setting[27], qc_tid_setting[31:28]
//	2	qc_eosp_setting[1:0], qc_ack_policy_setting[2], qc_amsdu_setting[3], qc_15to8_setting[11:4], reserved_5a[31:12]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_TX_FES_SETUP 3

struct tx_fes_setup {
    volatile uint32_t schedule_id                     : 16, //[15:0]
                      schedule_cmd_ring_id            :  5, //[20:16]
                      fes_control_mode                :  2, //[22:21]
                      number_of_users                 :  2, //[24:23]
                      schedule_tries                  :  4, //[28:25]
                      msdu_link_ext_endianness        :  1, //[29]
                      send_ndp                        :  1, //[30]
                      reserved_0a                     :  1; //[31]
    volatile uint32_t fc_to_ds_mask                   :  1, //[0]
                      fc_from_ds_mask                 :  1, //[1]
                      fc_more_frag_mask               :  1, //[2]
                      fc_retry_mask                   :  1, //[3]
                      fc_pwr_mgt_mask                 :  1, //[4]
                      fc_more_data_mask               :  1, //[5]
                      fc_prot_frame_mask              :  1, //[6]
                      fc_order_mask                   :  1, //[7]
                      duration_field_mask             :  1, //[8]
                      sequence_control_mask           :  1, //[9]
                      qc_tid_mask                     :  1, //[10]
                      qc_eosp_mask                    :  1, //[11]
                      qc_ack_policy_mask              :  1, //[12]
                      qc_amsdu_mask                   :  1, //[13]
                      reserved_1                      :  1, //[14]
                      qc_15to8_mask                   :  1, //[15]
                      iv_mask                         :  1, //[16]
                      fc_to_ds_setting                :  1, //[17]
                      fc_from_ds_setting              :  1, //[18]
                      fc_more_frag_setting            :  1, //[19]
                      fc_retry_setting                :  2, //[21:20]
                      fc_pwr_mgt_setting              :  1, //[22]
                      fc_more_data_setting            :  2, //[24:23]
                      fc_prot_frame_setting           :  2, //[26:25]
                      fc_order_setting                :  1, //[27]
                      qc_tid_setting                  :  4; //[31:28]
    volatile uint32_t qc_eosp_setting                 :  2, //[1:0]
                      qc_ack_policy_setting           :  1, //[2]
                      qc_amsdu_setting                :  1, //[3]
                      qc_15to8_setting                :  8, //[11:4]
                      reserved_5a                     : 20; //[31:12]
};

/*

schedule_id
			
			This field is overwritten by the scheduler module and
			it's value is coming from theschedule_id field in the 
			Scheduler command.
			
			
			
			Configured by scheduler in HW transmit mode
			
			A field that HW copies over into the scheduling status
			report, so that SW can determine to which scheduler command
			the status report belongs.
			
			This schedule ID is also reported in the PPDU status.   
			  
			
			<legal all>

schedule_cmd_ring_id
			
			This field is overwritten by the scheduler module and
			its value is based on the scheduler ring where the command
			is initiated.
			
			
			
			The schedule command ring  that originated this
			transmission
			
			<enum 0 sch_cmd_ring_number0>
			
			<enum 1 sch_cmd_ring_number1>
			
			<enum 2 sch_cmd_ring_number2>
			
			<enum 3 sch_cmd_ring_number3>
			
			<enum 4 sch_cmd_ring_number4>
			
			<enum 5 sch_cmd_ring_number5>
			
			<enum 6 sch_cmd_ring_number6>
			
			<enum 7 sch_cmd_ring_number7>
			
			<enum 8 sch_cmd_ring_number8>
			
			<enum 9 sch_cmd_ring_number9>
			
			<enum 10 sch_cmd_ring_number10>
			
			<enum 11 sch_cmd_ring_number11>
			
			<enum 12 sch_cmd_ring_number12>
			
			<enum 13 sch_cmd_ring_number13>
			
			<enum 14 sch_cmd_ring_number14>
			
			<enum 15 sch_cmd_ring_number15>
			
			
			
			<legal 0-15>

fes_control_mode
			
			<enum 0  SW_transmit_mode>  No HW generated TLVs
			
			<enum 1 PDG_transmit_mode> PDG  is activated to generate
			TLVs
			
			
			
			Note: Final Bandwidth selection is always performed by
			TX PCU.
			
			<legal 0-1> 

number_of_users
			
			The number of users in this transmission.
			
			In case of multiple users, the PCU TX will generate a TX
			FES status for each of the users.
			
			When number of users is 1, only user0 fields in any of
			the descriptors are applicable.
			
			When number of users is 2, only user0 and user1 fields
			are applicable.
			
			<legal 1-3>

schedule_tries
			
			The number of times this scheduler command has been
			tried
			
			<legal all>

msdu_link_ext_endianness
			
			<enum 0 LE> MSDU extension descriptor is Little Endian
			format
			
			<enum 1 BE> MSDU extension descriptor is Big Endian
			format
			
			<legal all>

send_ndp
			
			[TBD] Check this ....
			
			
			
			When set, PCU will transmit the NDP following the PPDU
			that is scheduled.
			
			(Note: If SW just wants to send an NDP on its own, not
			being proceeded by an NDP, it should do so by configuration
			of the PDG_BYPASS TLV).
			
			<legal all>

reserved_0a
			
			<legal 0>

fc_to_ds_mask
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi
			
			Note: Enc_type is NOT allowed b
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will get the
			setting from the frame_ctl field in the MPDU_queue extension
			data structure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the given in
			field: fc_to_ds_setting.
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
			
			
			
			<legal all>

fc_from_ds_mask
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will get the
			setting from the frame_ctl field in the MPDU_queue extension
			data structure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the given in
			field: fc_from_ds_setting.
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
			
			
			
			<legal all>

fc_more_frag_mask
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will get the
			setting from the frame_ctl field in the MPDU_queue extension
			data structure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the given in
			field: fc_more_frag_setting.
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
			
			
			
			<legal all>

fc_retry_mask
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will base the
			setting for this field on the retry_bitmap_31_0 and
			retry_bitmap_63_32 fields in the MPDU_queue_extension
			descriptor
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the given in
			field: fc_retry_setting.
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
			
			
			
			<legal all>

fc_pwr_mgt_mask
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will get the
			setting from the frame_ctl field in the MPDU_queue extension
			data structure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the given in
			field: fc_pwr_mgt_setting.
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
			
			
			
			<legal all>

fc_more_data_mask
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will get the
			setting from the frame_ctl field in the MPDU_queue extension
			data structure.
			
			
			
			TX_PCU has the abilty of overwrite the More data field,
			based on the Set_fc_more_data field in the PPDU_SS_... TLVs
			given by PDG.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the given in
			field: fc_more_data_setting.
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
			
			
			
			<legal all>

fc_prot_frame_mask
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will base the
			setting for the Protected frame bit on the key_type setting 
			in the peer entry. When NO encryption is needed, the bit
			will be set to 0, When the any encryption is needed, the bit
			will be set to 0.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the given in
			field: fc_prot_frame_setting. When fc_prot_frame_setting is
			set, OLE will encrypt the frame, based on the encryption
			type indicate with the key_type setting  in the peer entry
			
			
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
			
			<legal all>

fc_order_mask
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will get the
			setting from the frame_ctl field in the MPDU_queue extension
			data structure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the given in
			field: fc_order_setting.
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
			
			
			
			<legal all>

duration_field_mask
			
			Field only valid for MPDU frames with MSDU enc_type ==
			RAW or Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, TX PCU will get the
			value for this field from the Duration fields in the
			PPDU_SS_... TLVs from PDG.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (TX_PCU) will insert is coming from
			the Duration fields in the PPDU_SS_... TLVs from PDG
			(similar as with NON RAW/Native WiFi frames).
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.

sequence_control_mask
			
			Field only valid for MPDU frames with MSDU enc_type ==
			RAW or Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will base the
			value for  this field on the start_seq_num and 
			seqnum_bitmap_31_0, seqnum_bitmap_63_32 fields from the
			mpdu_queue_ext datastructure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the same as
			with  NON RAW/Native WiFi frames (see description above).
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.

qc_tid_mask
			
			Field only valid for MPDU frames with MSDU enc_type ==
			RAW or Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will base the
			value for  this field on the qos_ctl field from the
			MPDU_queue_ext data structure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the given in
			field: qc_tid_setting.
			
			
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.

qc_eosp_mask
			
			Field only valid for MPDU frames with MSDU enc_type ==
			RAW or Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will base the
			value for  this field on the qos_ctl field from the
			MPDU_queue_ext data structure.
			
			
			
			TX_PCU has the abilty of overwrite the QoS eosp field,
			based on the Set_fc_more_data field in the PPDU_SS_... TLVs
			given by PDG.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update the QoS
			eosp field. The value that HW (OLE) will insert is the given
			in field: qc_eosp_setting.
			
			
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.

qc_ack_policy_mask
			
			Field only valid for MPDU frames with MSDU enc_type ==
			RAW or Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will base the
			value for  this field on the qos_ctl field from the
			MPDU_queue_ext data structure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update the QoS
			ack policy field. The value that HW (OLE) will insert is
			determined by field: qc_ack_pol_setting.
			
			
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.

qc_amsdu_mask
			
			Field only valid for MPDU frames with MSDU enc_type ==
			RAW or Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will base the
			value for  this field on the qos_ctl field from the
			MPDU_queue_ext data structure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update the QoS
			amsdu field. The value that HW (OLE) will insert is
			determined by field: qc_amsdu_setting.
			
			
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.

reserved_1
			
			<legal 0>

qc_15to8_mask
			
			Field only valid for MPDU frames with MSDU enc_type ==
			RAW or Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will base the
			value for  this field on the qos_ctl field from the
			MPDU_queue_ext data structure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update the QoS
			control field, bits 15-8. The value that HW (OLE) will
			insert is determined by field: qc_15to8_setting.
			
			
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.

iv_mask
			
			Field only valid for MPDU frames with MSDU enc_type ==
			RAW or Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will base the
			IV field insertion/value on the on the encryption type
			indicate with the key_type setting  in the peer entry
			
			
			
			<enum 0 mask_disable>: OLE is allowed to overwrite the
			IV field, in case key_type setting  in the peer entry
			indicates some encryption.
			
			
			
			<enum 1 mask_enable>: OLE  is not allowed to overwrite
			any of the IV field contents.

fc_to_ds_setting
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Fc_to_ds_mask is not set.
			
			
			
			<enum 0 clear>: OLE will set the frame control field, to
			ds bit to 0
			
			<enum 1 set>: OLE will set the frame control field, to
			ds bit to 1
			
			<legal all>

fc_from_ds_setting
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Fc_from_ds_mask is not set.
			
			
			
			<enum 0 clear>: OLE will set the frame control field,
			from ds bit to 0
			
			<enum 1 set>: OLE will set the frame control field, from
			ds bit to 1
			
			<legal all>

fc_more_frag_setting
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Fc_more_frag_mask is not
			set.
			
			
			
			<enum 0 clear>: OLE will set the frame control field,
			more frag bit to 0
			
			<enum 1 set>: OLE will set the frame control field, more
			frag bit to 1
			
			<legal all>

fc_retry_setting
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Fc_retry_mask is not set.
			
			
			
			<enum 0 clear>: OLE will set the frame control field,
			retry bit to 0
			
			<enum 1 set>: OLE will set the frame control field,
			retry bit to 1
			
			<enum 2 retry_bimap_based>: OLE will base the setting
			for this field on the retry_bitmap_31_0 and
			retry_bitmap_63_32 fields in the MPDU_queue_extension
			descriptor
			
			
			
			<legal 0-2>

fc_pwr_mgt_setting
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Fc_pwr_mgt_mask is not set.
			
			
			
			<enum 0 clear>: OLE will set the frame control field,
			pwr_mgt bit to 0
			
			<enum 1 set>: OLE will set the frame control field,
			pwr_mgt bit to 1
			
			<legal all>

fc_more_data_setting
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Fc_more_Data_mask is not
			set.
			
			
			
			<enum 0 clear>: OLE will set the frame control field,
			More data bit to 0
			
			<enum 1 set>: OLE will set the frame control field, More
			data bit to 1
			
			
			
			<enum 2 pdg_based>: OLE will set the Frame control, More
			data bit to 0, but TX_PCU has the abilty to overwrite this
			based on the Set_fc_more_data field in the PPDU_SS_... TLVs
			given by PDG.
			
			
			
			<legal 0-2>

fc_prot_frame_setting
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Fc_prot_frame_mask is not
			set.
			
			
			
			<enum 0 clear>: OLE will set the frame control field ,
			order bit to 0
			
			<enum 1 set>: OLE will set the frame control field ,
			order bit to 1
			
			<enum 2 encap_type_based>: OLE configures the Frame
			Control field, Prot frame bit according to the following
			rule: When the encryption type indicated with the key_type
			setting  in the peer entry is set to no crypto, the fc
			prot_frame bit is set to zero. When the encryption type
			indicated with the key_type setting in the peer entry is set
			to some encryption  type, the OLE will encrypt the frame AND
			set the fc prot frame bit to 1.

fc_order_setting
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Fc_order_mask is not set.
			
			
			
			<enum 0 clear>: OLE will set the frame control field ,
			order bit to 0
			
			<enum 1 set>: OLE will set the frame control field ,
			order bit to 1
			
			<legal all>

qc_tid_setting
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Qc_tid_mask is not set.
			
			
			
			OLE sets the TID field in the QoS control field to this
			value.
			
			
			
			<legal all>

qc_eosp_setting
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Qc_eosp_mask is not set.
			
			
			
			<enum 0 clear>: OLE will set the QoS control bit to 0
			
			<enum 1 set>: OLE will set the QoS control bit to 1
			
			<enum 2 pdg_based>: OLE will set the QoS control bit to
			0, but TX_PCU has the abilty of overwrite the QoS eosp
			field, based on the Set_fc_more_data field in the
			PPDU_SS_... TLVs given by PDG.
			
			
			
			<legal 0-2>

qc_ack_policy_setting
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Qc_ack_policy_mask is not
			set.
			
			
			
			<enum 0 clear>: OLE will set the QoS control field ack
			policy bit to 0
			
			<enum 1 set>: OLE will set the QoS control ack policy
			bit to 1
			
			
			
			<legal all>

qc_amsdu_setting
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Qc_amsdu_mask is not set.
			
			
			
			<enum 0 clear>: OLE will set the QoS control field amsdu
			bit to 0
			
			<enum 1 set>: OLE will set the QoS control field amsdu
			bit to 1
			
			
			
			<legal all>

qc_15to8_setting
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Qc_15to8_mask is not set.
			
			
			
			OLE sets bit 8 to 16 in the QoS control field to this
			value.
			
			
			
			<legal all>

reserved_5a
			
			<legal 0>
*/


/* Description		TX_FES_SETUP_0_SCHEDULE_ID
			
			This field is overwritten by the scheduler module and
			it's value is coming from theschedule_id field in the 
			Scheduler command.
			
			
			
			Configured by scheduler in HW transmit mode
			
			A field that HW copies over into the scheduling status
			report, so that SW can determine to which scheduler command
			the status report belongs.
			
			This schedule ID is also reported in the PPDU status.   
			  
			
			<legal all>
*/
#define TX_FES_SETUP_0_SCHEDULE_ID_OFFSET                            0x00000000
#define TX_FES_SETUP_0_SCHEDULE_ID_LSB                               0
#define TX_FES_SETUP_0_SCHEDULE_ID_MASK                              0x0000ffff

/* Description		TX_FES_SETUP_0_SCHEDULE_CMD_RING_ID
			
			This field is overwritten by the scheduler module and
			its value is based on the scheduler ring where the command
			is initiated.
			
			
			
			The schedule command ring  that originated this
			transmission
			
			<enum 0 sch_cmd_ring_number0>
			
			<enum 1 sch_cmd_ring_number1>
			
			<enum 2 sch_cmd_ring_number2>
			
			<enum 3 sch_cmd_ring_number3>
			
			<enum 4 sch_cmd_ring_number4>
			
			<enum 5 sch_cmd_ring_number5>
			
			<enum 6 sch_cmd_ring_number6>
			
			<enum 7 sch_cmd_ring_number7>
			
			<enum 8 sch_cmd_ring_number8>
			
			<enum 9 sch_cmd_ring_number9>
			
			<enum 10 sch_cmd_ring_number10>
			
			<enum 11 sch_cmd_ring_number11>
			
			<enum 12 sch_cmd_ring_number12>
			
			<enum 13 sch_cmd_ring_number13>
			
			<enum 14 sch_cmd_ring_number14>
			
			<enum 15 sch_cmd_ring_number15>
			
			
			
			<legal 0-15>
*/
#define TX_FES_SETUP_0_SCHEDULE_CMD_RING_ID_OFFSET                   0x00000000
#define TX_FES_SETUP_0_SCHEDULE_CMD_RING_ID_LSB                      16
#define TX_FES_SETUP_0_SCHEDULE_CMD_RING_ID_MASK                     0x001f0000

/* Description		TX_FES_SETUP_0_FES_CONTROL_MODE
			
			<enum 0  SW_transmit_mode>  No HW generated TLVs
			
			<enum 1 PDG_transmit_mode> PDG  is activated to generate
			TLVs
			
			
			
			Note: Final Bandwidth selection is always performed by
			TX PCU.
			
			<legal 0-1> 
*/
#define TX_FES_SETUP_0_FES_CONTROL_MODE_OFFSET                       0x00000000
#define TX_FES_SETUP_0_FES_CONTROL_MODE_LSB                          21
#define TX_FES_SETUP_0_FES_CONTROL_MODE_MASK                         0x00600000

/* Description		TX_FES_SETUP_0_NUMBER_OF_USERS
			
			The number of users in this transmission.
			
			In case of multiple users, the PCU TX will generate a TX
			FES status for each of the users.
			
			When number of users is 1, only user0 fields in any of
			the descriptors are applicable.
			
			When number of users is 2, only user0 and user1 fields
			are applicable.
			
			<legal 1-3>
*/
#define TX_FES_SETUP_0_NUMBER_OF_USERS_OFFSET                        0x00000000
#define TX_FES_SETUP_0_NUMBER_OF_USERS_LSB                           23
#define TX_FES_SETUP_0_NUMBER_OF_USERS_MASK                          0x01800000

/* Description		TX_FES_SETUP_0_SCHEDULE_TRIES
			
			The number of times this scheduler command has been
			tried
			
			<legal all>
*/
#define TX_FES_SETUP_0_SCHEDULE_TRIES_OFFSET                         0x00000000
#define TX_FES_SETUP_0_SCHEDULE_TRIES_LSB                            25
#define TX_FES_SETUP_0_SCHEDULE_TRIES_MASK                           0x1e000000

/* Description		TX_FES_SETUP_0_MSDU_LINK_EXT_ENDIANNESS
			
			<enum 0 LE> MSDU extension descriptor is Little Endian
			format
			
			<enum 1 BE> MSDU extension descriptor is Big Endian
			format
			
			<legal all>
*/
#define TX_FES_SETUP_0_MSDU_LINK_EXT_ENDIANNESS_OFFSET               0x00000000
#define TX_FES_SETUP_0_MSDU_LINK_EXT_ENDIANNESS_LSB                  29
#define TX_FES_SETUP_0_MSDU_LINK_EXT_ENDIANNESS_MASK                 0x20000000

/* Description		TX_FES_SETUP_0_SEND_NDP
			
			[TBD] Check this ....
			
			
			
			When set, PCU will transmit the NDP following the PPDU
			that is scheduled.
			
			(Note: If SW just wants to send an NDP on its own, not
			being proceeded by an NDP, it should do so by configuration
			of the PDG_BYPASS TLV).
			
			<legal all>
*/
#define TX_FES_SETUP_0_SEND_NDP_OFFSET                               0x00000000
#define TX_FES_SETUP_0_SEND_NDP_LSB                                  30
#define TX_FES_SETUP_0_SEND_NDP_MASK                                 0x40000000

/* Description		TX_FES_SETUP_0_RESERVED_0A
			
			<legal 0>
*/
#define TX_FES_SETUP_0_RESERVED_0A_OFFSET                            0x00000000
#define TX_FES_SETUP_0_RESERVED_0A_LSB                               31
#define TX_FES_SETUP_0_RESERVED_0A_MASK                              0x80000000

/* Description		TX_FES_SETUP_1_FC_TO_DS_MASK
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi
			
			Note: Enc_type is NOT allowed b
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will get the
			setting from the frame_ctl field in the MPDU_queue extension
			data structure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the given in
			field: fc_to_ds_setting.
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
			
			
			
			<legal all>
*/
#define TX_FES_SETUP_1_FC_TO_DS_MASK_OFFSET                          0x00000004
#define TX_FES_SETUP_1_FC_TO_DS_MASK_LSB                             0
#define TX_FES_SETUP_1_FC_TO_DS_MASK_MASK                            0x00000001

/* Description		TX_FES_SETUP_1_FC_FROM_DS_MASK
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will get the
			setting from the frame_ctl field in the MPDU_queue extension
			data structure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the given in
			field: fc_from_ds_setting.
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
			
			
			
			<legal all>
*/
#define TX_FES_SETUP_1_FC_FROM_DS_MASK_OFFSET                        0x00000004
#define TX_FES_SETUP_1_FC_FROM_DS_MASK_LSB                           1
#define TX_FES_SETUP_1_FC_FROM_DS_MASK_MASK                          0x00000002

/* Description		TX_FES_SETUP_1_FC_MORE_FRAG_MASK
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will get the
			setting from the frame_ctl field in the MPDU_queue extension
			data structure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the given in
			field: fc_more_frag_setting.
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
			
			
			
			<legal all>
*/
#define TX_FES_SETUP_1_FC_MORE_FRAG_MASK_OFFSET                      0x00000004
#define TX_FES_SETUP_1_FC_MORE_FRAG_MASK_LSB                         2
#define TX_FES_SETUP_1_FC_MORE_FRAG_MASK_MASK                        0x00000004

/* Description		TX_FES_SETUP_1_FC_RETRY_MASK
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will base the
			setting for this field on the retry_bitmap_31_0 and
			retry_bitmap_63_32 fields in the MPDU_queue_extension
			descriptor
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the given in
			field: fc_retry_setting.
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
			
			
			
			<legal all>
*/
#define TX_FES_SETUP_1_FC_RETRY_MASK_OFFSET                          0x00000004
#define TX_FES_SETUP_1_FC_RETRY_MASK_LSB                             3
#define TX_FES_SETUP_1_FC_RETRY_MASK_MASK                            0x00000008

/* Description		TX_FES_SETUP_1_FC_PWR_MGT_MASK
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will get the
			setting from the frame_ctl field in the MPDU_queue extension
			data structure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the given in
			field: fc_pwr_mgt_setting.
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
			
			
			
			<legal all>
*/
#define TX_FES_SETUP_1_FC_PWR_MGT_MASK_OFFSET                        0x00000004
#define TX_FES_SETUP_1_FC_PWR_MGT_MASK_LSB                           4
#define TX_FES_SETUP_1_FC_PWR_MGT_MASK_MASK                          0x00000010

/* Description		TX_FES_SETUP_1_FC_MORE_DATA_MASK
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will get the
			setting from the frame_ctl field in the MPDU_queue extension
			data structure.
			
			
			
			TX_PCU has the abilty of overwrite the More data field,
			based on the Set_fc_more_data field in the PPDU_SS_... TLVs
			given by PDG.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the given in
			field: fc_more_data_setting.
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
			
			
			
			<legal all>
*/
#define TX_FES_SETUP_1_FC_MORE_DATA_MASK_OFFSET                      0x00000004
#define TX_FES_SETUP_1_FC_MORE_DATA_MASK_LSB                         5
#define TX_FES_SETUP_1_FC_MORE_DATA_MASK_MASK                        0x00000020

/* Description		TX_FES_SETUP_1_FC_PROT_FRAME_MASK
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will base the
			setting for the Protected frame bit on the key_type setting 
			in the peer entry. When NO encryption is needed, the bit
			will be set to 0, When the any encryption is needed, the bit
			will be set to 0.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the given in
			field: fc_prot_frame_setting. When fc_prot_frame_setting is
			set, OLE will encrypt the frame, based on the encryption
			type indicate with the key_type setting  in the peer entry
			
			
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
			
			<legal all>
*/
#define TX_FES_SETUP_1_FC_PROT_FRAME_MASK_OFFSET                     0x00000004
#define TX_FES_SETUP_1_FC_PROT_FRAME_MASK_LSB                        6
#define TX_FES_SETUP_1_FC_PROT_FRAME_MASK_MASK                       0x00000040

/* Description		TX_FES_SETUP_1_FC_ORDER_MASK
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will get the
			setting from the frame_ctl field in the MPDU_queue extension
			data structure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the given in
			field: fc_order_setting.
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
			
			
			
			<legal all>
*/
#define TX_FES_SETUP_1_FC_ORDER_MASK_OFFSET                          0x00000004
#define TX_FES_SETUP_1_FC_ORDER_MASK_LSB                             7
#define TX_FES_SETUP_1_FC_ORDER_MASK_MASK                            0x00000080

/* Description		TX_FES_SETUP_1_DURATION_FIELD_MASK
			
			Field only valid for MPDU frames with MSDU enc_type ==
			RAW or Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, TX PCU will get the
			value for this field from the Duration fields in the
			PPDU_SS_... TLVs from PDG.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (TX_PCU) will insert is coming from
			the Duration fields in the PPDU_SS_... TLVs from PDG
			(similar as with NON RAW/Native WiFi frames).
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
*/
#define TX_FES_SETUP_1_DURATION_FIELD_MASK_OFFSET                    0x00000004
#define TX_FES_SETUP_1_DURATION_FIELD_MASK_LSB                       8
#define TX_FES_SETUP_1_DURATION_FIELD_MASK_MASK                      0x00000100

/* Description		TX_FES_SETUP_1_SEQUENCE_CONTROL_MASK
			
			Field only valid for MPDU frames with MSDU enc_type ==
			RAW or Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will base the
			value for  this field on the start_seq_num and 
			seqnum_bitmap_31_0, seqnum_bitmap_63_32 fields from the
			mpdu_queue_ext datastructure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the same as
			with  NON RAW/Native WiFi frames (see description above).
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
*/
#define TX_FES_SETUP_1_SEQUENCE_CONTROL_MASK_OFFSET                  0x00000004
#define TX_FES_SETUP_1_SEQUENCE_CONTROL_MASK_LSB                     9
#define TX_FES_SETUP_1_SEQUENCE_CONTROL_MASK_MASK                    0x00000200

/* Description		TX_FES_SETUP_1_QC_TID_MASK
			
			Field only valid for MPDU frames with MSDU enc_type ==
			RAW or Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will base the
			value for  this field on the qos_ctl field from the
			MPDU_queue_ext data structure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update this
			field. The value that HW (OLE) will insert is the given in
			field: qc_tid_setting.
			
			
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
*/
#define TX_FES_SETUP_1_QC_TID_MASK_OFFSET                            0x00000004
#define TX_FES_SETUP_1_QC_TID_MASK_LSB                               10
#define TX_FES_SETUP_1_QC_TID_MASK_MASK                              0x00000400

/* Description		TX_FES_SETUP_1_QC_EOSP_MASK
			
			Field only valid for MPDU frames with MSDU enc_type ==
			RAW or Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will base the
			value for  this field on the qos_ctl field from the
			MPDU_queue_ext data structure.
			
			
			
			TX_PCU has the abilty of overwrite the QoS eosp field,
			based on the Set_fc_more_data field in the PPDU_SS_... TLVs
			given by PDG.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update the QoS
			eosp field. The value that HW (OLE) will insert is the given
			in field: qc_eosp_setting.
			
			
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
*/
#define TX_FES_SETUP_1_QC_EOSP_MASK_OFFSET                           0x00000004
#define TX_FES_SETUP_1_QC_EOSP_MASK_LSB                              11
#define TX_FES_SETUP_1_QC_EOSP_MASK_MASK                             0x00000800

/* Description		TX_FES_SETUP_1_QC_ACK_POLICY_MASK
			
			Field only valid for MPDU frames with MSDU enc_type ==
			RAW or Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will base the
			value for  this field on the qos_ctl field from the
			MPDU_queue_ext data structure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update the QoS
			ack policy field. The value that HW (OLE) will insert is
			determined by field: qc_ack_pol_setting.
			
			
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
*/
#define TX_FES_SETUP_1_QC_ACK_POLICY_MASK_OFFSET                     0x00000004
#define TX_FES_SETUP_1_QC_ACK_POLICY_MASK_LSB                        12
#define TX_FES_SETUP_1_QC_ACK_POLICY_MASK_MASK                       0x00001000

/* Description		TX_FES_SETUP_1_QC_AMSDU_MASK
			
			Field only valid for MPDU frames with MSDU enc_type ==
			RAW or Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will base the
			value for  this field on the qos_ctl field from the
			MPDU_queue_ext data structure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update the QoS
			amsdu field. The value that HW (OLE) will insert is
			determined by field: qc_amsdu_setting.
			
			
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
*/
#define TX_FES_SETUP_1_QC_AMSDU_MASK_OFFSET                          0x00000004
#define TX_FES_SETUP_1_QC_AMSDU_MASK_LSB                             13
#define TX_FES_SETUP_1_QC_AMSDU_MASK_MASK                            0x00002000

/* Description		TX_FES_SETUP_1_RESERVED_1
			
			<legal 0>
*/
#define TX_FES_SETUP_1_RESERVED_1_OFFSET                             0x00000004
#define TX_FES_SETUP_1_RESERVED_1_LSB                                14
#define TX_FES_SETUP_1_RESERVED_1_MASK                               0x00004000

/* Description		TX_FES_SETUP_1_QC_15TO8_MASK
			
			Field only valid for MPDU frames with MSDU enc_type ==
			RAW or Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will base the
			value for  this field on the qos_ctl field from the
			MPDU_queue_ext data structure.
			
			
			
			<enum 0 mask_disable>: HW is allowed to update the QoS
			control field, bits 15-8. The value that HW (OLE) will
			insert is determined by field: qc_15to8_setting.
			
			
			
			<enum 1 mask_enable>: HW is not allowed to update the
			contents of this field.
*/
#define TX_FES_SETUP_1_QC_15TO8_MASK_OFFSET                          0x00000004
#define TX_FES_SETUP_1_QC_15TO8_MASK_LSB                             15
#define TX_FES_SETUP_1_QC_15TO8_MASK_MASK                            0x00008000

/* Description		TX_FES_SETUP_1_IV_MASK
			
			Field only valid for MPDU frames with MSDU enc_type ==
			RAW or Native WiFi
			
			
			
			Note: 
			
			When enc_type != RAW or Native WiFi, OLE will base the
			IV field insertion/value on the on the encryption type
			indicate with the key_type setting  in the peer entry
			
			
			
			<enum 0 mask_disable>: OLE is allowed to overwrite the
			IV field, in case key_type setting  in the peer entry
			indicates some encryption.
			
			
			
			<enum 1 mask_enable>: OLE  is not allowed to overwrite
			any of the IV field contents.
*/
#define TX_FES_SETUP_1_IV_MASK_OFFSET                                0x00000004
#define TX_FES_SETUP_1_IV_MASK_LSB                                   16
#define TX_FES_SETUP_1_IV_MASK_MASK                                  0x00010000

/* Description		TX_FES_SETUP_1_FC_TO_DS_SETTING
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Fc_to_ds_mask is not set.
			
			
			
			<enum 0 clear>: OLE will set the frame control field, to
			ds bit to 0
			
			<enum 1 set>: OLE will set the frame control field, to
			ds bit to 1
			
			<legal all>
*/
#define TX_FES_SETUP_1_FC_TO_DS_SETTING_OFFSET                       0x00000004
#define TX_FES_SETUP_1_FC_TO_DS_SETTING_LSB                          17
#define TX_FES_SETUP_1_FC_TO_DS_SETTING_MASK                         0x00020000

/* Description		TX_FES_SETUP_1_FC_FROM_DS_SETTING
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Fc_from_ds_mask is not set.
			
			
			
			<enum 0 clear>: OLE will set the frame control field,
			from ds bit to 0
			
			<enum 1 set>: OLE will set the frame control field, from
			ds bit to 1
			
			<legal all>
*/
#define TX_FES_SETUP_1_FC_FROM_DS_SETTING_OFFSET                     0x00000004
#define TX_FES_SETUP_1_FC_FROM_DS_SETTING_LSB                        18
#define TX_FES_SETUP_1_FC_FROM_DS_SETTING_MASK                       0x00040000

/* Description		TX_FES_SETUP_1_FC_MORE_FRAG_SETTING
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Fc_more_frag_mask is not
			set.
			
			
			
			<enum 0 clear>: OLE will set the frame control field,
			more frag bit to 0
			
			<enum 1 set>: OLE will set the frame control field, more
			frag bit to 1
			
			<legal all>
*/
#define TX_FES_SETUP_1_FC_MORE_FRAG_SETTING_OFFSET                   0x00000004
#define TX_FES_SETUP_1_FC_MORE_FRAG_SETTING_LSB                      19
#define TX_FES_SETUP_1_FC_MORE_FRAG_SETTING_MASK                     0x00080000

/* Description		TX_FES_SETUP_1_FC_RETRY_SETTING
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Fc_retry_mask is not set.
			
			
			
			<enum 0 clear>: OLE will set the frame control field,
			retry bit to 0
			
			<enum 1 set>: OLE will set the frame control field,
			retry bit to 1
			
			<enum 2 retry_bimap_based>: OLE will base the setting
			for this field on the retry_bitmap_31_0 and
			retry_bitmap_63_32 fields in the MPDU_queue_extension
			descriptor
			
			
			
			<legal 0-2>
*/
#define TX_FES_SETUP_1_FC_RETRY_SETTING_OFFSET                       0x00000004
#define TX_FES_SETUP_1_FC_RETRY_SETTING_LSB                          20
#define TX_FES_SETUP_1_FC_RETRY_SETTING_MASK                         0x00300000

/* Description		TX_FES_SETUP_1_FC_PWR_MGT_SETTING
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Fc_pwr_mgt_mask is not set.
			
			
			
			<enum 0 clear>: OLE will set the frame control field,
			pwr_mgt bit to 0
			
			<enum 1 set>: OLE will set the frame control field,
			pwr_mgt bit to 1
			
			<legal all>
*/
#define TX_FES_SETUP_1_FC_PWR_MGT_SETTING_OFFSET                     0x00000004
#define TX_FES_SETUP_1_FC_PWR_MGT_SETTING_LSB                        22
#define TX_FES_SETUP_1_FC_PWR_MGT_SETTING_MASK                       0x00400000

/* Description		TX_FES_SETUP_1_FC_MORE_DATA_SETTING
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Fc_more_Data_mask is not
			set.
			
			
			
			<enum 0 clear>: OLE will set the frame control field,
			More data bit to 0
			
			<enum 1 set>: OLE will set the frame control field, More
			data bit to 1
			
			
			
			<enum 2 pdg_based>: OLE will set the Frame control, More
			data bit to 0, but TX_PCU has the abilty to overwrite this
			based on the Set_fc_more_data field in the PPDU_SS_... TLVs
			given by PDG.
			
			
			
			<legal 0-2>
*/
#define TX_FES_SETUP_1_FC_MORE_DATA_SETTING_OFFSET                   0x00000004
#define TX_FES_SETUP_1_FC_MORE_DATA_SETTING_LSB                      23
#define TX_FES_SETUP_1_FC_MORE_DATA_SETTING_MASK                     0x01800000

/* Description		TX_FES_SETUP_1_FC_PROT_FRAME_SETTING
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Fc_prot_frame_mask is not
			set.
			
			
			
			<enum 0 clear>: OLE will set the frame control field ,
			order bit to 0
			
			<enum 1 set>: OLE will set the frame control field ,
			order bit to 1
			
			<enum 2 encap_type_based>: OLE configures the Frame
			Control field, Prot frame bit according to the following
			rule: When the encryption type indicated with the key_type
			setting  in the peer entry is set to no crypto, the fc
			prot_frame bit is set to zero. When the encryption type
			indicated with the key_type setting in the peer entry is set
			to some encryption  type, the OLE will encrypt the frame AND
			set the fc prot frame bit to 1.
*/
#define TX_FES_SETUP_1_FC_PROT_FRAME_SETTING_OFFSET                  0x00000004
#define TX_FES_SETUP_1_FC_PROT_FRAME_SETTING_LSB                     25
#define TX_FES_SETUP_1_FC_PROT_FRAME_SETTING_MASK                    0x06000000

/* Description		TX_FES_SETUP_1_FC_ORDER_SETTING
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Fc_order_mask is not set.
			
			
			
			<enum 0 clear>: OLE will set the frame control field ,
			order bit to 0
			
			<enum 1 set>: OLE will set the frame control field ,
			order bit to 1
			
			<legal all>
*/
#define TX_FES_SETUP_1_FC_ORDER_SETTING_OFFSET                       0x00000004
#define TX_FES_SETUP_1_FC_ORDER_SETTING_LSB                          27
#define TX_FES_SETUP_1_FC_ORDER_SETTING_MASK                         0x08000000

/* Description		TX_FES_SETUP_1_QC_TID_SETTING
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Qc_tid_mask is not set.
			
			
			
			OLE sets the TID field in the QoS control field to this
			value.
			
			
			
			<legal all>
*/
#define TX_FES_SETUP_1_QC_TID_SETTING_OFFSET                         0x00000004
#define TX_FES_SETUP_1_QC_TID_SETTING_LSB                            28
#define TX_FES_SETUP_1_QC_TID_SETTING_MASK                           0xf0000000

/* Description		TX_FES_SETUP_2_QC_EOSP_SETTING
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Qc_eosp_mask is not set.
			
			
			
			<enum 0 clear>: OLE will set the QoS control bit to 0
			
			<enum 1 set>: OLE will set the QoS control bit to 1
			
			<enum 2 pdg_based>: OLE will set the QoS control bit to
			0, but TX_PCU has the abilty of overwrite the QoS eosp
			field, based on the Set_fc_more_data field in the
			PPDU_SS_... TLVs given by PDG.
			
			
			
			<legal 0-2>
*/
#define TX_FES_SETUP_2_QC_EOSP_SETTING_OFFSET                        0x00000008
#define TX_FES_SETUP_2_QC_EOSP_SETTING_LSB                           0
#define TX_FES_SETUP_2_QC_EOSP_SETTING_MASK                          0x00000003

/* Description		TX_FES_SETUP_2_QC_ACK_POLICY_SETTING
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Qc_ack_policy_mask is not
			set.
			
			
			
			<enum 0 clear>: OLE will set the QoS control field ack
			policy bit to 0
			
			<enum 1 set>: OLE will set the QoS control ack policy
			bit to 1
			
			
			
			<legal all>
*/
#define TX_FES_SETUP_2_QC_ACK_POLICY_SETTING_OFFSET                  0x00000008
#define TX_FES_SETUP_2_QC_ACK_POLICY_SETTING_LSB                     2
#define TX_FES_SETUP_2_QC_ACK_POLICY_SETTING_MASK                    0x00000004

/* Description		TX_FES_SETUP_2_QC_AMSDU_SETTING
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Qc_amsdu_mask is not set.
			
			
			
			<enum 0 clear>: OLE will set the QoS control field amsdu
			bit to 0
			
			<enum 1 set>: OLE will set the QoS control field amsdu
			bit to 1
			
			
			
			<legal all>
*/
#define TX_FES_SETUP_2_QC_AMSDU_SETTING_OFFSET                       0x00000008
#define TX_FES_SETUP_2_QC_AMSDU_SETTING_LSB                          3
#define TX_FES_SETUP_2_QC_AMSDU_SETTING_MASK                         0x00000008

/* Description		TX_FES_SETUP_2_QC_15TO8_SETTING
			
			Field only valid for MSDU frames with enc_type == RAW or
			Native WiFi.
			
			Field only valid when field Qc_15to8_mask is not set.
			
			
			
			OLE sets bit 8 to 16 in the QoS control field to this
			value.
			
			
			
			<legal all>
*/
#define TX_FES_SETUP_2_QC_15TO8_SETTING_OFFSET                       0x00000008
#define TX_FES_SETUP_2_QC_15TO8_SETTING_LSB                          4
#define TX_FES_SETUP_2_QC_15TO8_SETTING_MASK                         0x00000ff0

/* Description		TX_FES_SETUP_2_RESERVED_5A
			
			<legal 0>
*/
#define TX_FES_SETUP_2_RESERVED_5A_OFFSET                            0x00000008
#define TX_FES_SETUP_2_RESERVED_5A_LSB                               12
#define TX_FES_SETUP_2_RESERVED_5A_MASK                              0xfffff000


#endif // _TX_FES_SETUP_H_
