// Copyright (c) 2012 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _VECTOR_TRANSFER_START_H_
#define _VECTOR_TRANSFER_START_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	reserved_0[3:0], user_number[5:4], length[21:6], reserved[31:22]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_VECTOR_TRANSFER_START 1

struct vector_transfer_start {
    volatile uint32_t reserved_0                      :  4, //[3:0]
                      user_number                     :  2, //[5:4]
                      length                          : 16, //[21:6]
                      reserved                        : 10; //[31:22]
};

/*

reserved_0
			
			Reserved: Generator should set to 0 and the consumer
			shall ignore. <legal 0>

user_number
			
			Indicates user number for TX BF_CV transfer<legal 0-2>

length
			
			Number of octets in current vector frame - limited to
			64kbytes.  <legal all>   #### Actually 0 is not allowed

reserved
			
			Reserved: Generator should set to 0 and the consumer
			shall ignore. <legal 0>
*/


/* Description		VECTOR_TRANSFER_START_0_RESERVED_0
			
			Reserved: Generator should set to 0 and the consumer
			shall ignore. <legal 0>
*/
#define VECTOR_TRANSFER_START_0_RESERVED_0_OFFSET                    0x00000000
#define VECTOR_TRANSFER_START_0_RESERVED_0_LSB                       0
#define VECTOR_TRANSFER_START_0_RESERVED_0_MASK                      0x0000000f

/* Description		VECTOR_TRANSFER_START_0_USER_NUMBER
			
			Indicates user number for TX BF_CV transfer<legal 0-2>
*/
#define VECTOR_TRANSFER_START_0_USER_NUMBER_OFFSET                   0x00000000
#define VECTOR_TRANSFER_START_0_USER_NUMBER_LSB                      4
#define VECTOR_TRANSFER_START_0_USER_NUMBER_MASK                     0x00000030

/* Description		VECTOR_TRANSFER_START_0_LENGTH
			
			Number of octets in current vector frame - limited to
			64kbytes.  <legal all>   #### Actually 0 is not allowed
*/
#define VECTOR_TRANSFER_START_0_LENGTH_OFFSET                        0x00000000
#define VECTOR_TRANSFER_START_0_LENGTH_LSB                           6
#define VECTOR_TRANSFER_START_0_LENGTH_MASK                          0x003fffc0

/* Description		VECTOR_TRANSFER_START_0_RESERVED
			
			Reserved: Generator should set to 0 and the consumer
			shall ignore. <legal 0>
*/
#define VECTOR_TRANSFER_START_0_RESERVED_OFFSET                      0x00000000
#define VECTOR_TRANSFER_START_0_RESERVED_LSB                         22
#define VECTOR_TRANSFER_START_0_RESERVED_MASK                        0xffc00000


#endif // _VECTOR_TRANSFER_START_H_
