// Copyright (c) 2012 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _RX_PKT_END_H_
#define _RX_PKT_END_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	rx_success[0], error_rx_abort[1], error_rx_nap[2], error_tx_interrupt_rx[3], error_ofdm_power_drop[4], error_ofdm_restart[5], error_cck_power_drop[6], error_cck_restart[7], error_bt_collision[8], reserved[31:9]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_RX_PKT_END 1

struct rx_pkt_end {
    volatile uint32_t rx_success                      :  1, //[0]
                      error_rx_abort                  :  1, //[1]
                      error_rx_nap                    :  1, //[2]
                      error_tx_interrupt_rx           :  1, //[3]
                      error_ofdm_power_drop           :  1, //[4]
                      error_ofdm_restart              :  1, //[5]
                      error_cck_power_drop            :  1, //[6]
                      error_cck_restart               :  1, //[7]
                      error_bt_collision              :  1, //[8]
                      reserved                        : 23; //[31:9]
};

/*

rx_success
			
			PHY successfully completed transfer of PSDU

error_rx_abort
			
			PSDU terminated due to PHY_OFF message

error_rx_nap
			
			PSDU terminated due to RX_PHY_NAP message

error_tx_interrupt_rx
			
			PSDU terminated due to TX_PHY_DESC message during
			receive.  Any receive packet will be terminated if a
			transmit starts

error_ofdm_power_drop
			
			PSDU terminated due to power drop during OFDM reception

error_ofdm_restart
			
			PSDU terminated due to large increase in receive power
			during OFDM reception

error_cck_power_drop
			
			PSDU terminated due to power drop during CCK reception

error_cck_restart
			
			PSDU terminated due to large increase in receive power
			during CCK reception

error_bt_collision
			
			PHY will also set this field to 0.  This error is added
			by the MAC.

reserved
			
			Reserved: Generator should set to 0 and consumer shall
			ignore<legal 0>
*/


/* Description		RX_PKT_END_0_RX_SUCCESS
			
			PHY successfully completed transfer of PSDU
*/
#define RX_PKT_END_0_RX_SUCCESS_OFFSET                               0x00000000
#define RX_PKT_END_0_RX_SUCCESS_LSB                                  0
#define RX_PKT_END_0_RX_SUCCESS_MASK                                 0x00000001

/* Description		RX_PKT_END_0_ERROR_RX_ABORT
			
			PSDU terminated due to PHY_OFF message
*/
#define RX_PKT_END_0_ERROR_RX_ABORT_OFFSET                           0x00000000
#define RX_PKT_END_0_ERROR_RX_ABORT_LSB                              1
#define RX_PKT_END_0_ERROR_RX_ABORT_MASK                             0x00000002

/* Description		RX_PKT_END_0_ERROR_RX_NAP
			
			PSDU terminated due to RX_PHY_NAP message
*/
#define RX_PKT_END_0_ERROR_RX_NAP_OFFSET                             0x00000000
#define RX_PKT_END_0_ERROR_RX_NAP_LSB                                2
#define RX_PKT_END_0_ERROR_RX_NAP_MASK                               0x00000004

/* Description		RX_PKT_END_0_ERROR_TX_INTERRUPT_RX
			
			PSDU terminated due to TX_PHY_DESC message during
			receive.  Any receive packet will be terminated if a
			transmit starts
*/
#define RX_PKT_END_0_ERROR_TX_INTERRUPT_RX_OFFSET                    0x00000000
#define RX_PKT_END_0_ERROR_TX_INTERRUPT_RX_LSB                       3
#define RX_PKT_END_0_ERROR_TX_INTERRUPT_RX_MASK                      0x00000008

/* Description		RX_PKT_END_0_ERROR_OFDM_POWER_DROP
			
			PSDU terminated due to power drop during OFDM reception
*/
#define RX_PKT_END_0_ERROR_OFDM_POWER_DROP_OFFSET                    0x00000000
#define RX_PKT_END_0_ERROR_OFDM_POWER_DROP_LSB                       4
#define RX_PKT_END_0_ERROR_OFDM_POWER_DROP_MASK                      0x00000010

/* Description		RX_PKT_END_0_ERROR_OFDM_RESTART
			
			PSDU terminated due to large increase in receive power
			during OFDM reception
*/
#define RX_PKT_END_0_ERROR_OFDM_RESTART_OFFSET                       0x00000000
#define RX_PKT_END_0_ERROR_OFDM_RESTART_LSB                          5
#define RX_PKT_END_0_ERROR_OFDM_RESTART_MASK                         0x00000020

/* Description		RX_PKT_END_0_ERROR_CCK_POWER_DROP
			
			PSDU terminated due to power drop during CCK reception
*/
#define RX_PKT_END_0_ERROR_CCK_POWER_DROP_OFFSET                     0x00000000
#define RX_PKT_END_0_ERROR_CCK_POWER_DROP_LSB                        6
#define RX_PKT_END_0_ERROR_CCK_POWER_DROP_MASK                       0x00000040

/* Description		RX_PKT_END_0_ERROR_CCK_RESTART
			
			PSDU terminated due to large increase in receive power
			during CCK reception
*/
#define RX_PKT_END_0_ERROR_CCK_RESTART_OFFSET                        0x00000000
#define RX_PKT_END_0_ERROR_CCK_RESTART_LSB                           7
#define RX_PKT_END_0_ERROR_CCK_RESTART_MASK                          0x00000080

/* Description		RX_PKT_END_0_ERROR_BT_COLLISION
			
			PHY will also set this field to 0.  This error is added
			by the MAC.
*/
#define RX_PKT_END_0_ERROR_BT_COLLISION_OFFSET                       0x00000000
#define RX_PKT_END_0_ERROR_BT_COLLISION_LSB                          8
#define RX_PKT_END_0_ERROR_BT_COLLISION_MASK                         0x00000100

/* Description		RX_PKT_END_0_RESERVED
			
			Reserved: Generator should set to 0 and consumer shall
			ignore<legal 0>
*/
#define RX_PKT_END_0_RESERVED_OFFSET                                 0x00000000
#define RX_PKT_END_0_RESERVED_LSB                                    9
#define RX_PKT_END_0_RESERVED_MASK                                   0xfffffe00


#endif // _RX_PKT_END_H_
