// Copyright (c) 2012 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _L_SIG_A_H_
#define _L_SIG_A_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	rate[3:0], lsig_reserved[4], length[16:5], parity[17], tail[23:18], rx_pkt_type[25:24], reserved[31:26]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_L_SIG_A 1

struct l_sig_a {
    volatile uint32_t rate                            :  4, //[3:0]
                      lsig_reserved                   :  1, //[4]
                      length                          : 12, //[16:5]
                      parity                          :  1, //[17]
                      tail                            :  6, //[23:18]
                      rx_pkt_type                     :  2, //[25:24]
                      reserved                        :  6; //[31:26]
};

/*

rate
			
			This format is originally defined for OFDM as a 4 bit
			field but the 5th bit was added to indicate 11b formatted
			frames.  In the standard bit [4] is specified as reserved. 
			For 11b frames this L-SIG is transformed in the PHY into the
			11b preamble format.  The following are the rates:
			
			<enum 8     ofdm_48_mbps> 64-QAM 2/3 (48 Mbps)
			
			<enum 9     ofdm_24_mbps> 16-QAM 1/2 (24 Mbps)
			
			<enum 10     ofdm_12_mbps> QPSK 1/2 (12 Mbps)
			
			<enum 11     ofdm_6_mbps> BPSK 1/2 (6 Mbps)
			
			<enum 12     ofdm_54_mbps> 64-QAM 3/4 (54 Mbps)
			
			<enum 13     ofdm_36_mbps> 16-QAM 3/4 (36 Mbps)
			
			<enum 14     ofdm_18_mbps> QPSK 1/2 (18 Mbps)
			
			<enum 15     ofdm_9_mbps> BPSK 3/4 (9 Mbps)
			
			<legal 8-15>

lsig_reserved
			
			Reserved: Should be set to 0 by the MAC and ignored by
			the PHY
			
			<legal 0>

length
			
			The length indicates the number of octets in this MPDU. 
			Note that when using mixed mode 11n preamble this length
			provides the spoofed length for the PPDU.  This length
			provides part of the information to derive the actually PPDU
			length.  For legacy OFDM and 11B frames the maximum length
			is 
			
			<legal all>

parity
			
			11a/n/ac TX: This field provides even parity over the
			first 18 bits of the signal field which means that the sum
			of 1s in the signal field will always be even on
			
			11a/n/ac RX: this field contains the received parity
			field from the L-SIG symbol for the current packet.
			
			<legal 0-1>

tail
			
			The 6 bits of tail is always set to 0 is used to flush
			the BCC encoder and decoder.  <legal 0>

rx_pkt_type
			
			Note: This is not really part of L-SIG
			
			11a/n/ac TX: This field is reserved and ignored by the
			PHY.
			
			11a/n/ac RX: This field contains the decoded RX packet
			type.
			
			<enum 0     dot11a>
			
			<enum 1     dot11b>
			
			<enum 2     dot11n_mm>
			
			<enum 3     dot11ac>
			
			<legal 0-3>

reserved
			
			Reserved: Should be set to 0 by the transmitting MAC and
			ignored by the PHY <legal 0>
*/


/* Description		L_SIG_A_0_RATE
			
			This format is originally defined for OFDM as a 4 bit
			field but the 5th bit was added to indicate 11b formatted
			frames.  In the standard bit [4] is specified as reserved. 
			For 11b frames this L-SIG is transformed in the PHY into the
			11b preamble format.  The following are the rates:
			
			<enum 8     ofdm_48_mbps> 64-QAM 2/3 (48 Mbps)
			
			<enum 9     ofdm_24_mbps> 16-QAM 1/2 (24 Mbps)
			
			<enum 10     ofdm_12_mbps> QPSK 1/2 (12 Mbps)
			
			<enum 11     ofdm_6_mbps> BPSK 1/2 (6 Mbps)
			
			<enum 12     ofdm_54_mbps> 64-QAM 3/4 (54 Mbps)
			
			<enum 13     ofdm_36_mbps> 16-QAM 3/4 (36 Mbps)
			
			<enum 14     ofdm_18_mbps> QPSK 1/2 (18 Mbps)
			
			<enum 15     ofdm_9_mbps> BPSK 3/4 (9 Mbps)
			
			<legal 8-15>
*/
#define L_SIG_A_0_RATE_OFFSET                                        0x00000000
#define L_SIG_A_0_RATE_LSB                                           0
#define L_SIG_A_0_RATE_MASK                                          0x0000000f

/* Description		L_SIG_A_0_LSIG_RESERVED
			
			Reserved: Should be set to 0 by the MAC and ignored by
			the PHY
			
			<legal 0>
*/
#define L_SIG_A_0_LSIG_RESERVED_OFFSET                               0x00000000
#define L_SIG_A_0_LSIG_RESERVED_LSB                                  4
#define L_SIG_A_0_LSIG_RESERVED_MASK                                 0x00000010

/* Description		L_SIG_A_0_LENGTH
			
			The length indicates the number of octets in this MPDU. 
			Note that when using mixed mode 11n preamble this length
			provides the spoofed length for the PPDU.  This length
			provides part of the information to derive the actually PPDU
			length.  For legacy OFDM and 11B frames the maximum length
			is 
			
			<legal all>
*/
#define L_SIG_A_0_LENGTH_OFFSET                                      0x00000000
#define L_SIG_A_0_LENGTH_LSB                                         5
#define L_SIG_A_0_LENGTH_MASK                                        0x0001ffe0

/* Description		L_SIG_A_0_PARITY
			
			11a/n/ac TX: This field provides even parity over the
			first 18 bits of the signal field which means that the sum
			of 1s in the signal field will always be even on
			
			11a/n/ac RX: this field contains the received parity
			field from the L-SIG symbol for the current packet.
			
			<legal 0-1>
*/
#define L_SIG_A_0_PARITY_OFFSET                                      0x00000000
#define L_SIG_A_0_PARITY_LSB                                         17
#define L_SIG_A_0_PARITY_MASK                                        0x00020000

/* Description		L_SIG_A_0_TAIL
			
			The 6 bits of tail is always set to 0 is used to flush
			the BCC encoder and decoder.  <legal 0>
*/
#define L_SIG_A_0_TAIL_OFFSET                                        0x00000000
#define L_SIG_A_0_TAIL_LSB                                           18
#define L_SIG_A_0_TAIL_MASK                                          0x00fc0000

/* Description		L_SIG_A_0_RX_PKT_TYPE
			
			Note: This is not really part of L-SIG
			
			11a/n/ac TX: This field is reserved and ignored by the
			PHY.
			
			11a/n/ac RX: This field contains the decoded RX packet
			type.
			
			<enum 0     dot11a>
			
			<enum 1     dot11b>
			
			<enum 2     dot11n_mm>
			
			<enum 3     dot11ac>
			
			<legal 0-3>
*/
#define L_SIG_A_0_RX_PKT_TYPE_OFFSET                                 0x00000000
#define L_SIG_A_0_RX_PKT_TYPE_LSB                                    24
#define L_SIG_A_0_RX_PKT_TYPE_MASK                                   0x03000000

/* Description		L_SIG_A_0_RESERVED
			
			Reserved: Should be set to 0 by the transmitting MAC and
			ignored by the PHY <legal 0>
*/
#define L_SIG_A_0_RESERVED_OFFSET                                    0x00000000
#define L_SIG_A_0_RESERVED_LSB                                       26
#define L_SIG_A_0_RESERVED_MASK                                      0xfc000000


#endif // _L_SIG_A_H_
