﻿aui.text = {};

/* string functions */
aui.text.String = {};
aui.text.String.capitalize = function(str){
	return str.replace(/^[a-z]/, function(a){return a.toUpperCase()});
}
aui.text.String.trim = function(str){
    return str.replace(/^\s+|\s+$/g, '');
}
aui.text.String.padLeft = function(str, len, sig){
    sig = sig || "0", str = new String(str);
    for(len; len>str.length; ) str = sig+str;
    return str;
}
/* string functions */

/* number functions */
aui.text.Number = {};

aui.text.Number.formatFloat = function(num, pos){
    var tmp = Math.pow(10, pos);
    return Math.round(num*tmp) / tmp;
}
/**
* @function
* number to string with 0 inhead
*/
aui.text.Number.pad = function(num, dig){
	dig = dig || 2;
	num+="";
	for(var i = dig, j = num.length; i > j ; i--) num = "0" + num;
	
    return num;
};
/* number functions */

/* file functions */
aui.text.file = {};
/* parse filename */
aui.text.file.parse = function(filename){
    var obj = {
        path : null,
        name : null,
        ext : null
    };
    /* trim: remove empty string */
    var str = aui.lang.string.trim(filename);
    str = str.replace( /[^\\\/:*?\"\'<>|]+\.[a-z]+$/i, function(a, b){
        var temp = a.split(".");
        obj.name = temp[0];
        obj.ext = temp[1];
        return;
    } );
    obj.path = /[\\\/]$/.test(str) ? str : str+"\\";
    return obj;
}
/* combine filename */
aui.text.file.combine = function(options){
    /* options = { path, name, ext } */
    var regPath = /([\\\/])[^\\\/]+$/;
    return options.path.replace( regPath, function(a,b){return a+b} ) + options.name + "." + options.ext;
}
/* file functions */

/* array functions */
Array.inArray = function(ary, str){
    for(var i in ary) if(ary[i]==str) return true;
    return false;
}
/* array functions */

/* object functions */
aui.text.object = {};
aui.text.object.isEmpty = function(obj){
    for(var i in obj) 
        break;
    return i===undefined;
}
/* object functions */