﻿aui.ui.Dialog.Waiting = function(options){
    this.options = {
        className: 'aui-ui-Dialog-Waiting',
        width:170,
        height:122,
        message:null,
		corner: "none",
        hotkey:false,
        minimumDisplayTime: 1000
    };
    this.options = aui.lang.merge(this.options, options || {});
    this.onClose = new aui.lang.util.CustomEvent("onClose", this);
    this.minimumDisplayTime = this.options.minimumDisplayTime;

    aui.ui.Dialog.Waiting.superclass.constructor.call(this, this.options);
};

aui.lang.Class.extend( aui.ui.Dialog.Waiting, aui.ui.Dialog.DialogBase, {
	prepareDialog: function(nodeToAppend){
	    var backgroundImg = NewObj("div", "img");
	    var messageLine = NewObj("div", "msg");
	    if (this.options.message)
	        messageLine.innerText = this.options.message;
	    nodeToAppend.appendChild(backgroundImg);
	    nodeToAppend.appendChild(messageLine);
	},
	
	_itsDone:false,
	_countdown: null,
//	minimumDisplayTime: 1500, //at least show 1.5sec saving window, don't just flash!
	showDialog: function(config){
	    var me = this;
	    
	    window.clearTimeout(this._countdown);
        aui.ui.Dialog.Waiting.superclass.showDialog.call(this, config);	    
        this._itsDone = false;        
        
        function hideDialog(){
            try{
                me._countdown = null;
                if(me._itsDone) me.hideDialog();
            }catch(e){}
        }
        this._countdown = window.setTimeout(hideDialog, this.minimumDisplayTime);        
	},
	
	hideDialog:function(){
	    this._itsDone = true;
        if(this._countdown) return;
        
        aui.ui.Dialog.Waiting.superclass.hideDialog.call(this);	 
        this.onClose.fire();
        this.onClose.unsubscribe();
	},
	
	resetCountDown: function(timeout){
	    var me = this;
	    
	    window.clearTimeout(this._countdown);
	    
	    function hideDialog(){
            try{
                me._countdown = null;
                if(me._itsDone) me.hideDialog();
            }catch(e){}
        }
        
	    this._countdown = window.setTimeout(hideDialog, timeout);
	}
});

//dlgLoading = new aui.ui.Dialog.Waiting({message: "Loading"});
//dlgLoading.showDialog();