/***************************************************************************

 *

 * Company: Rohde & Schwarz

 *

 * Project: NrpControl2.dll port for linux

 *

 * $Workfile: nrpdef.h $

 *

 * Author: Stefani Seibold

 *

 * Date of creation: 26.05.2006

 *

 ***************************************************************************/



#ifndef	__NRPDEF_H__

#define	__NRPDEF_H__



/* Error code offset 0x80000000 */

#define	NRP_ERROR_OFFSET			( 0x80000000UL )

#define NRP_ERROR_USB_OFFSET		( NRP_ERROR_OFFSET + 0x60000000 ) /* 0xE000000 */

#define NRP_ERROR_DEVICE_OFFSET		( NRP_ERROR_OFFSET + 0x50000000 ) /* 0xD000000 */

#define NRP_ERROR_CONTROL_OFFSET	( NRP_ERROR_OFFSET + 0x40000000 ) /* 0xC000000 */



/*ERROR CODES */

#define NRP_SUCCESS				(0x0L)



#define	NRP_ERROR_READ_BUFFER_ALLOC			(NRP_ERROR_USB_OFFSET + 0x0FFF0001 ) /* 0xEFFF0001 */

#define NRP_ERROR_START_READ_THREAD			(NRP_ERROR_USB_OFFSET + 0x0FFF0002 ) /* 0xEFFF0002 */

#define NRP_ERROR_NULL_DEVICE_LIST			(NRP_ERROR_USB_OFFSET + 0x0FFF0003 ) /* 0xEFFF0003 */



#define NRP_ERROR_USB_DISCONNECTED			(NRP_ERROR_CONTROL_OFFSET +  1) /* 0xC0000001 */

#define NRP_ERROR_INVALID_RESOURCE			(NRP_ERROR_CONTROL_OFFSET +  2) /* 0xC0000002 */

#define NRP_ERROR_NOT_SUPPORTED_CALLBACK	(NRP_ERROR_CONTROL_OFFSET +  3) /* 0xC0000003 */

#define NRP_ERROR_TIMEOUT					(NRP_ERROR_CONTROL_OFFSET +  4) /* 0xC0000004 */

#define NRP_ERROR_DEVICE_DISCONNECTED		(NRP_ERROR_CONTROL_OFFSET +  5) /* 0xC0000005 */

#define NRP_ERROR_INVALID_SESSION			(NRP_ERROR_CONTROL_OFFSET +  6) /* 0xC0000006 */

#define NRP_ERROR_CONFIGURATION_STORE		(NRP_ERROR_CONTROL_OFFSET +  7) /* 0xC0000007 */

#define NRP_ERROR_DESCRIPTOR_INDEX			(NRP_ERROR_CONTROL_OFFSET +  8) /* 0xC0000008 */

#define NRP_ERROR_LOGICAL_NAME_EXIST		(NRP_ERROR_CONTROL_OFFSET +  9) /* 0xC0000009 */

#define NRP_ERROR_DATA_QUEUE_EMPTY			(NRP_ERROR_CONTROL_OFFSET + 10) /* 0xC000000A */

#define NRP_ERROR_STRING_QUEUE_EMPTY		(NRP_ERROR_CONTROL_OFFSET + 11) /* 0xC000000B */

#define NRP_ERROR_FLOAT_QUEUE_EMPTY			(NRP_ERROR_CONTROL_OFFSET + 12) /* 0xC000000C */

#define NRP_ERROR_LONG_QUEUE_EMPTY			(NRP_ERROR_CONTROL_OFFSET + 13) /* 0xC000000D */

#define NRP_ERROR_BITFIELD_QUEUE_EMPTY		(NRP_ERROR_CONTROL_OFFSET + 14) /* 0xC000000E */

#define NRP_ERROR_BINARY_QUEUE_EMPTY		(NRP_ERROR_CONTROL_OFFSET + 15) /* 0xC000000F */

#define NRP_ERROR_FLOAT_ARRAY_QUEUE_EMPTY	(NRP_ERROR_CONTROL_OFFSET + 16) /* 0xC0000010 */

#define NRP_ERROR_PARAMETER1				(NRP_ERROR_CONTROL_OFFSET + 17) /* 0xC0000011 */

#define NRP_ERROR_PARAMETER2				(NRP_ERROR_CONTROL_OFFSET + 18) /* 0xC0000012 */

#define NRP_ERROR_PARAMETER3				(NRP_ERROR_CONTROL_OFFSET + 19) /* 0xC0000013 */

#define NRP_ERROR_PARAMETER4				(NRP_ERROR_CONTROL_OFFSET + 20) /* 0xC0000014 */

#define NRP_ERROR_PARAMETER5				(NRP_ERROR_CONTROL_OFFSET + 21) /* 0xC0000015 */

#define NRP_ERROR_PARAMETER6				(NRP_ERROR_CONTROL_OFFSET + 22) /* 0xC0000016 */

#define NRP_ERROR_SMALL_BUFFER_SIZE			(NRP_ERROR_CONTROL_OFFSET + 23) /* 0xC0000017 */

#define NRP_ERROR_UNKNOWN_TRIGGER_STATE		(NRP_ERROR_CONTROL_OFFSET + 24) /* 0xC0000018 */

#define NRP_ERROR_INVALID_SERIAL_NUMBER		(NRP_ERROR_CONTROL_OFFSET + 25) /* 0xC0000019 */

#define NRP_ERROR_INVALID_SENSOR_TYPE		(NRP_ERROR_CONTROL_OFFSET + 26) /* 0xC000001A */

#define NRP_ERROR_INCORRECT_DATA_ORDER		(NRP_ERROR_CONTROL_OFFSET + 27) /* 0xC000001B */

#define NRP_ERROR_UNKNOWN_ATTRIBUTE			(NRP_ERROR_CONTROL_OFFSET + 28) /* 0xC000001C */

#define NRP_ERROR_RESTRICTED_FOR_ONE_SENSOR	(NRP_ERROR_CONTROL_OFFSET + 29) /* 0xC000001D */

#define NRP_ERROR_BOOTLOADER_FAIL			(NRP_ERROR_CONTROL_OFFSET + 30) /* 0xC000001E */

#define NRP_ERROR_SESSION_DESTROY			(NRP_ERROR_CONTROL_OFFSET + 31) /* 0xC000001F */

#define NRP_ERROR_NOT_CONNECTED_SENSOR		(NRP_ERROR_CONTROL_OFFSET + 32) /* 0xC0000020 */

// ....

//



/* Sensor specific errors */

#define NRP_ERROR_DEVICE_CALDATA_FORMAT			( NRP_ERROR_DEVICE_OFFSET + 0x01 )

#define NRP_ERROR_DEVICE_OVERRANGE				( NRP_ERROR_DEVICE_OFFSET + 0x02 )

#define NRP_ERROR_DEVICE_NOTINSERVICEMODE		( NRP_ERROR_DEVICE_OFFSET + 0x03 )

#define NRP_ERROR_DEVICE_CALZERO				( NRP_ERROR_DEVICE_OFFSET + 0x04 )

#define NRP_ERROR_DEVICE_TRIGGERQUEUEFULL		( NRP_ERROR_DEVICE_OFFSET + 0x05 )

#define NRP_ERROR_DEVICE_EVENTQUEUEFULL			( NRP_ERROR_DEVICE_OFFSET + 0x06 )

#define NRP_ERROR_DEVICE_SAMPLEERROR			( NRP_ERROR_DEVICE_OFFSET + 0x07 )

#define NRP_ERROR_DEVICE_OVERLOAD				( NRP_ERROR_DEVICE_OFFSET + 0x08 )

#define NRP_ERROR_DEVICE_HARDWARE				( NRP_ERROR_DEVICE_OFFSET + 0x09 )

#define NRP_ERROR_DEVICE_CHECKSUM				( NRP_ERROR_DEVICE_OFFSET + 0x0a )

#define NRP_ERROR_DEVICE_ILLEGALSERIAL			( NRP_ERROR_DEVICE_OFFSET + 0x0b )

#define NRP_ERROR_DEVICE_FILTERTRUNCATED		( NRP_ERROR_DEVICE_OFFSET + 0x0c )

#define NRP_ERROR_DEVICE_BURST_TOO_SHORT		( NRP_ERROR_DEVICE_OFFSET + 0x0d )

#define NRP_ERROR_DEVICE_COMMUNICATION_ERROR	( NRP_ERROR_DEVICE_OFFSET + 0x0e )



/* fatal errors */

#define NRP_ERROR_DEVICE_GENERIC				( NRP_ERROR_DEVICE_OFFSET + 0x80 )

#define NRP_ERROR_DEVICE_OVERMAX				( NRP_ERROR_DEVICE_OFFSET + 0x81 )

#define NRP_ERROR_DEVICE_UNDERMIN				( NRP_ERROR_DEVICE_OFFSET + 0x82 )

#define NRP_ERROR_DEVICE_VOLTAGE				( NRP_ERROR_DEVICE_OFFSET + 0x83 )  /*  +/- 5Volt not correct */

#define NRP_ERROR_DEVICE_SYNTAX					( NRP_ERROR_DEVICE_OFFSET + 0x84 )

#define NRP_ERROR_DEVICE_MEMORY					( NRP_ERROR_DEVICE_OFFSET + 0x85 )

#define NRP_ERROR_DEVICE_PARAMETER				( NRP_ERROR_DEVICE_OFFSET + 0x86 )

#define NRP_ERROR_DEVICE_TIMING					( NRP_ERROR_DEVICE_OFFSET + 0x87 )

#define NRP_ERROR_DEVICE_NOTIDLE				( NRP_ERROR_DEVICE_OFFSET + 0x88 )

#define NRP_ERROR_DEVICE_UNKNOWNCOMMAND			( NRP_ERROR_DEVICE_OFFSET + 0x89 )

#define NRP_ERROR_DEVICE_OUTBUFFERFULL			( NRP_ERROR_DEVICE_OFFSET + 0x8a )

#define NRP_ERROR_DEVICE_FLASHPROG				( NRP_ERROR_DEVICE_OFFSET + 0x8b )

#define NRP_ERROR_DEVICE_CALDATANOTPRESENT		( NRP_ERROR_DEVICE_OFFSET + 0x8c )



/* usb defines */

#define MAX_READ_ERRORS	5



#define VRI_DEVICE_NAME			5

#define VRT_GET_DEVICE_INFO		6

#define VRT_RESET_ALL			1

#define VRT_SET_DEVICE_CLEAR	8 



/* Nrp Attributes */

#define NRP_ATTR_BOOTLOADER_VERSION         (0x3FFF0000L)  /* string */

#define NRP_ATTR_MAJOR_VERSION              (0x3FFF0001L)

#define NRP_ATTR_MINOR_VERSION              (0x3FFF0002L)

#define NRP_ATTR_USER_DATA                  (0x3FFF0007L)

#define NRP_ATTR_FORCE_USER_DATA            (0x3FFF0008L)

#define NRP_ATTR_DISTANCE_DEFAULT           (0x3FFF0010L)

#define NRP_ATTR_DISTANCE_LONG              (0x3FFF0011L)

#define NRP_ATTR_DISTANCE_ANYWHERE_USB      (0x3FFF0012L)



/*

 * All data types available for read from Nrp senosrs

 */

typedef enum

{

	DATA_BINARYBLOCK=0,

	DATA_BITFIELDLIMIT=1,

	DATA_BITFIELDPARAM=2,

	DATA_BITFIELDFEATURE=3,

	DATA_FLOATARRAY=4,

	DATA_FLOATLIMIT=5,

	DATA_FLOATPARAM=6,

	DATA_FLOATRESULT=7,

	DATA_LONGLIMIT=8,

	DATA_LONGPARAM=9,

	DATA_STRING=10,

	DATA_AUXFLOATARRAY=11,

	DATA_NROF=12

} EDataType;



/*

 * Trigger states

 */

typedef enum

{

	NRP_TRIGGER_UNKNOWN=-1,

	NRP_TRIGGER_IDLE=0,

	NRP_TRIGGER_RESERVED=1,

	NRP_TRIGGER_WAIT_FOR_TRIGGER=2,

	NRP_TRIGGER_MEASURING=3

} ETriggerState;



typedef void (*Nrp_CommandAcceptedFuncPtr)(long session,long groupParam,long userArgument);

typedef void (*Nrp_DataAvailableFuncPtr)(long session,long dataType,long userArgument);

typedef void (*Nrp_ErrorOccurredFuncPtr)(long session,long errorCode,long userArgument);

typedef void (*Nrp_StateChangedFuncPtr)(long session,long sensorTriggerState,long userArgument);

typedef void (*Nrp_StillAliveFuncPtr)(long session,long sensorTriggerState,long userArgument);

typedef void (*Nrp_DeviceChangedFuncPtr)(long userArgument);



#endif



/* vi:set ts=4 sw=4: */



