// Copyright (c) 2012 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _PCU_PPDU_SETUP_H_
#define _PCU_PPDU_SETUP_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	transmit_fes_type[3:0], medium_prot_type[6:4], su_response_type[9:7], reserved_0_a[17:10], mprot_required_bw20[18], mprot_required_bw40[19], mprot_required_bw80[20], ppdu_allow_bw20[21], ppdu_allow_bw40[22], ppdu_allow_bw80[23], reserved_0[31:24]
//	1	location_req[0], location_type[1], expect_ndp[2], ndp_feedback_type[3], reserved_1a[4], ndp_nc_index[7:5], ndp_nc_override[8], expect_cbf[9], cbf_user_number[11:10], reserved_1b[31:12]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_PCU_PPDU_SETUP 2

struct pcu_ppdu_setup {
    volatile uint32_t transmit_fes_type               :  4, //[3:0]
                      medium_prot_type                :  3, //[6:4]
                      su_response_type                :  3, //[9:7]
                      reserved_0_a                    :  8, //[17:10]
                      mprot_required_bw20             :  1, //[18]
                      mprot_required_bw40             :  1, //[19]
                      mprot_required_bw80             :  1, //[20]
                      ppdu_allow_bw20                 :  1, //[21]
                      ppdu_allow_bw40                 :  1, //[22]
                      ppdu_allow_bw80                 :  1, //[23]
                      reserved_0                      :  8; //[31:24]
    volatile uint32_t location_req                    :  1, //[0]
                      location_type                   :  1, //[1]
                      expect_ndp                      :  1, //[2]
                      ndp_feedback_type               :  1, //[3]
                      reserved_1a                     :  1, //[4]
                      ndp_nc_index                    :  3, //[7:5]
                      ndp_nc_override                 :  1, //[8]
                      expect_cbf                      :  1, //[9]
                      cbf_user_number                 :  2, //[11:10]
                      reserved_1b                     : 20; //[31:12]
};

/*

transmit_fes_type
			
			<enum 0 self_gen_bar> A self-generated BAR frame is
			transmitted. 
			
			SU transmission only.
			
			<enum 1 self_gen_data_null> A self-generated Data null
			frame is transmitted. SU transmission only.
			
			<enum 2 self_gen_qos_null> A self-generated QoS null
			frame is transmitted. SU transmission only.
			
			<enum 3 self_gen_cf_end> A self-generated CF-end frame
			is transmitted. SU transmission only
			
			<enum 4 regular_transmission>  A Scheduled SU
			transmission
			
			
			
			15-5 Reserved

medium_prot_type
			
			Self Gen Medium Protection type used
			
			0: No protection
			
			1: RTS (legacy)
			
			2: RTS (11ac static bandwidth)
			
			3: RTS (11ac dynamic bandwidth)
			
			4: CTS2Self
			
			5-7: Reserved

su_response_type
			
			PPDU transmission Response type expected in case of SU
			transmission
			
			0: No response expected
			
			1: ACK expected2: BA expected
			
			3: Action No Ack frame expected (after NDP)
			
			7-4: Reserved

reserved_0_a
			
			<legal 0>

mprot_required_bw20
			
			Field only valid when ppdu_allowed_bw20 is set.
			
			
			
			When set, Medium protection transmission is required for
			a 20 MHz bandwidth PPDU transmission <legal all>

mprot_required_bw40
			
			Field only valid when ppdu_allowed_bw40 is set.
			
			
			
			When set, Medium protection transmission is required for
			a 40 MHz bandwidth PPDU transmission <legal all>

mprot_required_bw80
			
			Field only valid when ppdu_allowed_bw80 is set.
			
			
			
			When set, Medium protection transmission is required for
			a 80 MHz bandwidth PPDU transmission <legal all>

ppdu_allow_bw20
			
			When set, allow PPDU transmission with 20 MHz bandwidth
			<legal all>

ppdu_allow_bw40
			
			When set, allow PPDU transmission with 40 MHz bandwidth
			<legal all>

ppdu_allow_bw80
			
			When set, allow PPDU transmission with 80 MHz bandwidth
			<legal all>

reserved_0
			
			<legal 0>

location_req
			
			When set, a TX_LOCATION_REQ TLV should be generated by
			the PCU to the PHY TX  before this transmission starts.

location_type
			
			This field is only valid when Location_req is set.
			
			This field is used to define what kind of RTT response
			is required by the MAC and it is inserted into the
			TX_LOCATION_REQ TLV generated by the TX PCU
			
			<enum 0     ifft_response>   Indicates iFFT response
			format
			
			
			<legal 0-1>

expect_ndp
			
			When set, a TX_EXPECT_NDP TLV should be generated by the
			TX PCU to the PHY.
			
			
			
			Used for debugging purposes and to allow alternative
			Frame eschange sequences

ndp_feedback_type
			
			This field is only valid when expect_ndp is set.
			
			This field is inserted into the TX_EXPECT_NDP TLV
			generated by the TX PCU.
			
			
			
			<enum 0     11ac_su>  Expect 11ac NDP and create SU
			feedback
			
			<enum 1     11ac_mu>  Expect 11ac NDP and create MU
			feedback
			
			<legal 2-3>

reserved_1a
			
			Reserved: Generator should set to 0, Consumer shall
			ignore.  <legal 0>

ndp_nc_index
			
			This field is only valid when expect_ndp is set.
			
			This field is inserted into the TX_EXPECT_NDP TLV
			generated by the TX PCU.
			
			
			
			Defines the dimension Nc for the beamforming feedback
			matrix. Nc_index values > 3 are not supported in Beeliner.
			
			<legal 0-3>

ndp_nc_override
			
			This field is only valid when expect_ndp is set.
			
			This field is inserted into the TX_EXPECT_NDP TLV
			generated by the TX PCU.
			
			
			
			This bit is set if the PHY is required to override its
			internally-calculated Nc value with the one provided by the
			MAC in this TLV.  <legal 0-1>

expect_cbf
			
			When set, a TX_EXPECT_NDP TLV should be generated by the
			TX PCU to the PHY after the transmission of the PPDU.

cbf_user_number
			
			This field is only valid when expect_cbf is set.
			
			This field is inserted into the TX_EXPECT_CBF TLV
			generated by the TX PCU.
			
			
			
			Defines the source of the expected CBF.  
			
			<legal 0-3>

reserved_1b
			
			<legal 0>
*/


/* Description		PCU_PPDU_SETUP_0_TRANSMIT_FES_TYPE
			
			<enum 0 self_gen_bar> A self-generated BAR frame is
			transmitted. 
			
			SU transmission only.
			
			<enum 1 self_gen_data_null> A self-generated Data null
			frame is transmitted. SU transmission only.
			
			<enum 2 self_gen_qos_null> A self-generated QoS null
			frame is transmitted. SU transmission only.
			
			<enum 3 self_gen_cf_end> A self-generated CF-end frame
			is transmitted. SU transmission only
			
			<enum 4 regular_transmission>  A Scheduled SU
			transmission
			
			
			
			15-5 Reserved
*/
#define PCU_PPDU_SETUP_0_TRANSMIT_FES_TYPE_OFFSET                    0x00000000
#define PCU_PPDU_SETUP_0_TRANSMIT_FES_TYPE_LSB                       0
#define PCU_PPDU_SETUP_0_TRANSMIT_FES_TYPE_MASK                      0x0000000f

/* Description		PCU_PPDU_SETUP_0_MEDIUM_PROT_TYPE
			
			Self Gen Medium Protection type used
			
			0: No protection
			
			1: RTS (legacy)
			
			2: RTS (11ac static bandwidth)
			
			3: RTS (11ac dynamic bandwidth)
			
			4: CTS2Self
			
			5-7: Reserved
*/
#define PCU_PPDU_SETUP_0_MEDIUM_PROT_TYPE_OFFSET                     0x00000000
#define PCU_PPDU_SETUP_0_MEDIUM_PROT_TYPE_LSB                        4
#define PCU_PPDU_SETUP_0_MEDIUM_PROT_TYPE_MASK                       0x00000070

/* Description		PCU_PPDU_SETUP_0_SU_RESPONSE_TYPE
			
			PPDU transmission Response type expected in case of SU
			transmission
			
			0: No response expected
			
			1: ACK expected2: BA expected
			
			3: Action No Ack frame expected (after NDP)
			
			7-4: Reserved
*/
#define PCU_PPDU_SETUP_0_SU_RESPONSE_TYPE_OFFSET                     0x00000000
#define PCU_PPDU_SETUP_0_SU_RESPONSE_TYPE_LSB                        7
#define PCU_PPDU_SETUP_0_SU_RESPONSE_TYPE_MASK                       0x00000380

/* Description		PCU_PPDU_SETUP_0_RESERVED_0_A
			
			<legal 0>
*/
#define PCU_PPDU_SETUP_0_RESERVED_0_A_OFFSET                         0x00000000
#define PCU_PPDU_SETUP_0_RESERVED_0_A_LSB                            10
#define PCU_PPDU_SETUP_0_RESERVED_0_A_MASK                           0x0003fc00

/* Description		PCU_PPDU_SETUP_0_MPROT_REQUIRED_BW20
			
			Field only valid when ppdu_allowed_bw20 is set.
			
			
			
			When set, Medium protection transmission is required for
			a 20 MHz bandwidth PPDU transmission <legal all>
*/
#define PCU_PPDU_SETUP_0_MPROT_REQUIRED_BW20_OFFSET                  0x00000000
#define PCU_PPDU_SETUP_0_MPROT_REQUIRED_BW20_LSB                     18
#define PCU_PPDU_SETUP_0_MPROT_REQUIRED_BW20_MASK                    0x00040000

/* Description		PCU_PPDU_SETUP_0_MPROT_REQUIRED_BW40
			
			Field only valid when ppdu_allowed_bw40 is set.
			
			
			
			When set, Medium protection transmission is required for
			a 40 MHz bandwidth PPDU transmission <legal all>
*/
#define PCU_PPDU_SETUP_0_MPROT_REQUIRED_BW40_OFFSET                  0x00000000
#define PCU_PPDU_SETUP_0_MPROT_REQUIRED_BW40_LSB                     19
#define PCU_PPDU_SETUP_0_MPROT_REQUIRED_BW40_MASK                    0x00080000

/* Description		PCU_PPDU_SETUP_0_MPROT_REQUIRED_BW80
			
			Field only valid when ppdu_allowed_bw80 is set.
			
			
			
			When set, Medium protection transmission is required for
			a 80 MHz bandwidth PPDU transmission <legal all>
*/
#define PCU_PPDU_SETUP_0_MPROT_REQUIRED_BW80_OFFSET                  0x00000000
#define PCU_PPDU_SETUP_0_MPROT_REQUIRED_BW80_LSB                     20
#define PCU_PPDU_SETUP_0_MPROT_REQUIRED_BW80_MASK                    0x00100000

/* Description		PCU_PPDU_SETUP_0_PPDU_ALLOW_BW20
			
			When set, allow PPDU transmission with 20 MHz bandwidth
			<legal all>
*/
#define PCU_PPDU_SETUP_0_PPDU_ALLOW_BW20_OFFSET                      0x00000000
#define PCU_PPDU_SETUP_0_PPDU_ALLOW_BW20_LSB                         21
#define PCU_PPDU_SETUP_0_PPDU_ALLOW_BW20_MASK                        0x00200000

/* Description		PCU_PPDU_SETUP_0_PPDU_ALLOW_BW40
			
			When set, allow PPDU transmission with 40 MHz bandwidth
			<legal all>
*/
#define PCU_PPDU_SETUP_0_PPDU_ALLOW_BW40_OFFSET                      0x00000000
#define PCU_PPDU_SETUP_0_PPDU_ALLOW_BW40_LSB                         22
#define PCU_PPDU_SETUP_0_PPDU_ALLOW_BW40_MASK                        0x00400000

/* Description		PCU_PPDU_SETUP_0_PPDU_ALLOW_BW80
			
			When set, allow PPDU transmission with 80 MHz bandwidth
			<legal all>
*/
#define PCU_PPDU_SETUP_0_PPDU_ALLOW_BW80_OFFSET                      0x00000000
#define PCU_PPDU_SETUP_0_PPDU_ALLOW_BW80_LSB                         23
#define PCU_PPDU_SETUP_0_PPDU_ALLOW_BW80_MASK                        0x00800000

/* Description		PCU_PPDU_SETUP_0_RESERVED_0
			
			<legal 0>
*/
#define PCU_PPDU_SETUP_0_RESERVED_0_OFFSET                           0x00000000
#define PCU_PPDU_SETUP_0_RESERVED_0_LSB                              24
#define PCU_PPDU_SETUP_0_RESERVED_0_MASK                             0xff000000

/* Description		PCU_PPDU_SETUP_1_LOCATION_REQ
			
			When set, a TX_LOCATION_REQ TLV should be generated by
			the PCU to the PHY TX  before this transmission starts.
*/
#define PCU_PPDU_SETUP_1_LOCATION_REQ_OFFSET                         0x00000004
#define PCU_PPDU_SETUP_1_LOCATION_REQ_LSB                            0
#define PCU_PPDU_SETUP_1_LOCATION_REQ_MASK                           0x00000001

/* Description		PCU_PPDU_SETUP_1_LOCATION_TYPE
			
			This field is only valid when Location_req is set.
			
			This field is used to define what kind of RTT response
			is required by the MAC and it is inserted into the
			TX_LOCATION_REQ TLV generated by the TX PCU
			
			<enum 0     ifft_response>   Indicates iFFT response
			format
			
			
			<legal 0-1>
*/
#define PCU_PPDU_SETUP_1_LOCATION_TYPE_OFFSET                        0x00000004
#define PCU_PPDU_SETUP_1_LOCATION_TYPE_LSB                           1
#define PCU_PPDU_SETUP_1_LOCATION_TYPE_MASK                          0x00000002

/* Description		PCU_PPDU_SETUP_1_EXPECT_NDP
			
			When set, a TX_EXPECT_NDP TLV should be generated by the
			TX PCU to the PHY.
			
			
			
			Used for debugging purposes and to allow alternative
			Frame eschange sequences
*/
#define PCU_PPDU_SETUP_1_EXPECT_NDP_OFFSET                           0x00000004
#define PCU_PPDU_SETUP_1_EXPECT_NDP_LSB                              2
#define PCU_PPDU_SETUP_1_EXPECT_NDP_MASK                             0x00000004

/* Description		PCU_PPDU_SETUP_1_NDP_FEEDBACK_TYPE
			
			This field is only valid when expect_ndp is set.
			
			This field is inserted into the TX_EXPECT_NDP TLV
			generated by the TX PCU.
			
			
			
			<enum 0     11ac_su>  Expect 11ac NDP and create SU
			feedback
			
			<enum 1     11ac_mu>  Expect 11ac NDP and create MU
			feedback
			
			<legal 2-3>
*/
#define PCU_PPDU_SETUP_1_NDP_FEEDBACK_TYPE_OFFSET                    0x00000004
#define PCU_PPDU_SETUP_1_NDP_FEEDBACK_TYPE_LSB                       3
#define PCU_PPDU_SETUP_1_NDP_FEEDBACK_TYPE_MASK                      0x00000008

/* Description		PCU_PPDU_SETUP_1_RESERVED_1A
			
			Reserved: Generator should set to 0, Consumer shall
			ignore.  <legal 0>
*/
#define PCU_PPDU_SETUP_1_RESERVED_1A_OFFSET                          0x00000004
#define PCU_PPDU_SETUP_1_RESERVED_1A_LSB                             4
#define PCU_PPDU_SETUP_1_RESERVED_1A_MASK                            0x00000010

/* Description		PCU_PPDU_SETUP_1_NDP_NC_INDEX
			
			This field is only valid when expect_ndp is set.
			
			This field is inserted into the TX_EXPECT_NDP TLV
			generated by the TX PCU.
			
			
			
			Defines the dimension Nc for the beamforming feedback
			matrix. Nc_index values > 3 are not supported in Beeliner.
			
			<legal 0-3>
*/
#define PCU_PPDU_SETUP_1_NDP_NC_INDEX_OFFSET                         0x00000004
#define PCU_PPDU_SETUP_1_NDP_NC_INDEX_LSB                            5
#define PCU_PPDU_SETUP_1_NDP_NC_INDEX_MASK                           0x000000e0

/* Description		PCU_PPDU_SETUP_1_NDP_NC_OVERRIDE
			
			This field is only valid when expect_ndp is set.
			
			This field is inserted into the TX_EXPECT_NDP TLV
			generated by the TX PCU.
			
			
			
			This bit is set if the PHY is required to override its
			internally-calculated Nc value with the one provided by the
			MAC in this TLV.  <legal 0-1>
*/
#define PCU_PPDU_SETUP_1_NDP_NC_OVERRIDE_OFFSET                      0x00000004
#define PCU_PPDU_SETUP_1_NDP_NC_OVERRIDE_LSB                         8
#define PCU_PPDU_SETUP_1_NDP_NC_OVERRIDE_MASK                        0x00000100

/* Description		PCU_PPDU_SETUP_1_EXPECT_CBF
			
			When set, a TX_EXPECT_NDP TLV should be generated by the
			TX PCU to the PHY after the transmission of the PPDU.
*/
#define PCU_PPDU_SETUP_1_EXPECT_CBF_OFFSET                           0x00000004
#define PCU_PPDU_SETUP_1_EXPECT_CBF_LSB                              9
#define PCU_PPDU_SETUP_1_EXPECT_CBF_MASK                             0x00000200

/* Description		PCU_PPDU_SETUP_1_CBF_USER_NUMBER
			
			This field is only valid when expect_cbf is set.
			
			This field is inserted into the TX_EXPECT_CBF TLV
			generated by the TX PCU.
			
			
			
			Defines the source of the expected CBF.  
			
			<legal 0-3>
*/
#define PCU_PPDU_SETUP_1_CBF_USER_NUMBER_OFFSET                      0x00000004
#define PCU_PPDU_SETUP_1_CBF_USER_NUMBER_LSB                         10
#define PCU_PPDU_SETUP_1_CBF_USER_NUMBER_MASK                        0x00000c00

/* Description		PCU_PPDU_SETUP_1_RESERVED_1B
			
			<legal 0>
*/
#define PCU_PPDU_SETUP_1_RESERVED_1B_OFFSET                          0x00000004
#define PCU_PPDU_SETUP_1_RESERVED_1B_LSB                             12
#define PCU_PPDU_SETUP_1_RESERVED_1B_MASK                            0xfffff000


#endif // _PCU_PPDU_SETUP_H_
