// Copyright (c) 2012 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _VHT_SIG_B_MU20_H_
#define _VHT_SIG_B_MU20_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	length[15:0], mcs[19:16], tail[25:20], mu_user_number[28:26], user_number[31:29]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_VHT_SIG_B_MU20 1

struct vht_sig_b_mu20 {
    volatile uint32_t length                          : 16, //[15:0]
                      mcs                             :  4, //[19:16]
                      tail                            :  6, //[25:20]
                      mu_user_number                  :  3, //[28:26]
                      user_number                     :  3; //[31:29]
};

/*

length
			
			VHT-SIG-B Length (in units of 4 octets) = ceiling
			(LENGTH/4)  <legal all>

mcs
			
			Modulation as described in vht_sig_a mcs field <legal
			0-9>

tail
			
			Used to terminate the trellis of the convolutional
			decoder.
			
			Set to 0.  <legal 0>

mu_user_number
			
			Not part of VHT-SIG-B.
			
			Mapping from user number to mu_user_number  <legal 0-3>

user_number
			
			Not part of VHT-SIG-B.
			
			Defines which user this SIG-B word corresponds to during
			MU transmission. For MU packet reception, this field shall
			indicate the user number decoded by the PHY (for diagnostic
			purposes). <legal 0-2>
*/


/* Description		VHT_SIG_B_MU20_0_LENGTH
			
			VHT-SIG-B Length (in units of 4 octets) = ceiling
			(LENGTH/4)  <legal all>
*/
#define VHT_SIG_B_MU20_0_LENGTH_OFFSET                               0x00000000
#define VHT_SIG_B_MU20_0_LENGTH_LSB                                  0
#define VHT_SIG_B_MU20_0_LENGTH_MASK                                 0x0000ffff

/* Description		VHT_SIG_B_MU20_0_MCS
			
			Modulation as described in vht_sig_a mcs field <legal
			0-9>
*/
#define VHT_SIG_B_MU20_0_MCS_OFFSET                                  0x00000000
#define VHT_SIG_B_MU20_0_MCS_LSB                                     16
#define VHT_SIG_B_MU20_0_MCS_MASK                                    0x000f0000

/* Description		VHT_SIG_B_MU20_0_TAIL
			
			Used to terminate the trellis of the convolutional
			decoder.
			
			Set to 0.  <legal 0>
*/
#define VHT_SIG_B_MU20_0_TAIL_OFFSET                                 0x00000000
#define VHT_SIG_B_MU20_0_TAIL_LSB                                    20
#define VHT_SIG_B_MU20_0_TAIL_MASK                                   0x03f00000

/* Description		VHT_SIG_B_MU20_0_MU_USER_NUMBER
			
			Not part of VHT-SIG-B.
			
			Mapping from user number to mu_user_number  <legal 0-3>
*/
#define VHT_SIG_B_MU20_0_MU_USER_NUMBER_OFFSET                       0x00000000
#define VHT_SIG_B_MU20_0_MU_USER_NUMBER_LSB                          26
#define VHT_SIG_B_MU20_0_MU_USER_NUMBER_MASK                         0x1c000000

/* Description		VHT_SIG_B_MU20_0_USER_NUMBER
			
			Not part of VHT-SIG-B.
			
			Defines which user this SIG-B word corresponds to during
			MU transmission. For MU packet reception, this field shall
			indicate the user number decoded by the PHY (for diagnostic
			purposes). <legal 0-2>
*/
#define VHT_SIG_B_MU20_0_USER_NUMBER_OFFSET                          0x00000000
#define VHT_SIG_B_MU20_0_USER_NUMBER_LSB                             29
#define VHT_SIG_B_MU20_0_USER_NUMBER_MASK                            0xe0000000


#endif // _VHT_SIG_B_MU20_H_
