// Copyright (c) 2012 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _PDG_SETUP_USERX_H_
#define _PDG_SETUP_USERX_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	max_ampdu_size[19:0], pcu_data_threshold_20[23:20], pcu_data_threshold_40[27:24], pcu_data_threshold_80[31:28]
//	1	max_mpdu_cnt[6:0], mu_user_number[9:7], min_mpdu_spacing_bw20[19:10], sta_pwr_state[20], reserved_1[23:21], fixed_delim_padding_bw20[31:24]
//	2	pdg_eosp_control_enable[0], pdg_eosp_set_threshold[7:1], reserved_2a[9:8], min_mpdu_spacing_bw40[19:10], reserved_2b[23:20], fixed_delim_padding_bw80[31:24]
//	3	pdg_more_data_control_enable[0], pdg_more_data_set_threshold[7:1], reserved_3a[9:8], min_mpdu_spacing_bw80[19:10], reserved_3b[23:20], fixed_delim_padding_bw40[31:24]
//	4-5	struct tx_rate_setting tx_rate_ctr_ppdu_bw20;
//	6-7	struct tx_rate_setting tx_rate_ctr_ppdu_bw40;
//	8-9	struct tx_rate_setting tx_rate_ctr_ppdu_bw80;
//	10-11	struct tx_rate_setting response_rate_bw20;
//	12-13	struct tx_rate_setting response_rate_bw40;
//	14-15	struct tx_rate_setting response_rate_bw80;
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_PDG_SETUP_USERX 16

struct pdg_setup_userx {
    volatile uint32_t max_ampdu_size                  : 20, //[19:0]
                      pcu_data_threshold_20           :  4, //[23:20]
                      pcu_data_threshold_40           :  4, //[27:24]
                      pcu_data_threshold_80           :  4; //[31:28]
    volatile uint32_t max_mpdu_cnt                    :  7, //[6:0]
                      mu_user_number                  :  3, //[9:7]
                      min_mpdu_spacing_bw20           : 10, //[19:10]
                      sta_pwr_state                   :  1, //[20]
                      reserved_1                      :  3, //[23:21]
                      fixed_delim_padding_bw20        :  8; //[31:24]
    volatile uint32_t pdg_eosp_control_enable         :  1, //[0]
                      pdg_eosp_set_threshold          :  7, //[7:1]
                      reserved_2a                     :  2, //[9:8]
                      min_mpdu_spacing_bw40           : 10, //[19:10]
                      reserved_2b                     :  4, //[23:20]
                      fixed_delim_padding_bw80        :  8; //[31:24]
    volatile uint32_t pdg_more_data_control_enable    :  1, //[0]
                      pdg_more_data_set_threshold     :  7, //[7:1]
                      reserved_3a                     :  2, //[9:8]
                      min_mpdu_spacing_bw80           : 10, //[19:10]
                      reserved_3b                     :  4, //[23:20]
                      fixed_delim_padding_bw40        :  8; //[31:24]
    struct            tx_rate_setting                       tx_rate_ctr_ppdu_bw20;
    struct            tx_rate_setting                       tx_rate_ctr_ppdu_bw40;
    struct            tx_rate_setting                       tx_rate_ctr_ppdu_bw80;
    struct            tx_rate_setting                       response_rate_bw20;
    struct            tx_rate_setting                       response_rate_bw40;
    struct            tx_rate_setting                       response_rate_bw80;
};

/*

max_ampdu_size
			
			The maximum number of bytes in the PPDU transmission.

pcu_data_threshold_20
			
			Field only valid for 20MHz BW transmissions
			
			The minimum amount of MPDU data present in the TX PCU
			buffer, before TX PCU allows this MPDU data to transfer to
			the PHY. This threshold prevents or reduces data underrun
			conditions during an MPDU transmission. 
			
			If an entire MPDU frame is present in the TX PCU buffer
			that is smaller than this threshold value, this threshold is
			ignored, and MPDU data transfer to the PHY is allowed to
			start.
			
			In units of 256 bytes.
			
			<legal all>

pcu_data_threshold_40
			
			Field only valid for 40MHz BW transmissions
			
			The minimum amount of MPDU data present in the TX PCU
			buffer, before TX PCU allows this MPDU data to transfer to
			the PHY. This threshold prevents or reduces data underrun
			conditions during an MPDU transmission. 
			
			If an entire MPDU frame is present in the TX PCU buffer
			that is smaller than this threshold value, this threshold is
			ignored, and MPDU data transfer to the PHY is allowed to
			start.
			
			In units of 256 bytes.
			
			<legal all>

pcu_data_threshold_80
			
			Field only valid for 80MHz BW transmissions
			
			The minimum amount of MPDU data present in the TX PCU
			buffer, before TX PCU allows this MPDU data to transfer to
			the PHY. This threshold prevents or reduces data underrun
			conditions during an MPDU transmission. 
			
			If an entire MPDU frame is present in the TX PCU buffer
			that is smaller than this threshold value, this threshold is
			ignored, and MPDU data transfer to the PHY is allowed to
			start.
			
			In units of 256 bytes.
			
			<legal all>

max_mpdu_cnt
			
			The maximum number of MPDUs in the PPDU transmission.
			
			Note: This is different than A-MPDU window size given in
			the Queue extension descriptor. This field allows per
			scheduler command fine-tuning control.

mu_user_number
			
			Mapping from user number to mu_user_number.  This is the
			mapping of this user for the GID that is being used.<legal
			0-3>

min_mpdu_spacing_bw20
			
			Minimum number of dwords in an MPDU.  If the actual MPDU
			size is smaller than this, the PCU will insert zero-length
			delimiters after this MPDU to compensate for the difference.
			For example at a PHY rate of 1.3 Gbps if the receiver is
			capable of receiving only 1 MPDU every 16 usec, then this
			field should be set to 649.  This means that if the MPDU
			length is shorter than 2596 bytes then additional zero
			length delimiter and MAC byte padding should be added to get
			to a combined byte count of 2596 bytes.  This does not
			include the non-zero length delimiter.

sta_pwr_state
			
			The power state of the destination STA
			
			
			
			0: STA not in power save mode
			
			1: STA is in power save mode
			
			
			
			This setting is needed by PDG to determine if the
			This_queue_more_data bit in the PCU_PPDU_SETUP TLV needs to
			be set.

reserved_1
			
			Generator should set to 0 and consumer will ignore. 
			<legal 0>

fixed_delim_padding_bw20
			
			A fixed number of zero-length delimiters to add after
			each MPDU.The actual number of zero-length delimiters will
			be maximum of this field and the amount based on the
			min_mpdu_spacing field.

pdg_eosp_control_enable
			
			PDG based eosp bit assertion enabled
			
			
			
			0: No action
			
			1: When PDG is calculating the amount of frames that can
			be sent in the upcoming Frame Exchange Sequence, it will
			have to check if that amount is equal to the in field
			eosp_set_threshold indicated number of frames. When this is
			the case, PDG will signal TXP PCU to set the EOSP bit in all
			of those frames.
			
			Note that this indication might be set for the 80Mhz
			transmission, but for example not for the 20 Mhz
			transmission (which had less number of frames).
			
			<legal all>

pdg_eosp_set_threshold
			
			
			When pdg determines that this number of frames can be
			transmitted in the upcoming transmission, PDG will signal to
			the TX PCU that the EOSP bit in the frames need to be set.
			
			It is up to sw to make sure that eosp_set_threshold is
			always equal or larger then Max_mpdu_cnt.
			
			<legal all>

reserved_2a
			
			Generator should set to 0 and consumer will ignore. 
			<legal 0>

min_mpdu_spacing_bw40
			
			Minimum number of dwords in an MPDU.  If the actual MPDU
			size is smaller than this, the PCU will insert zero-length
			delimiters after this MPDU to compensate for the difference.
			For example at a PHY rate of 1.3 Gbps if the receiver is
			capable of receiving only 1 MPDU every 16 usec, then this
			field should be set to 649.  This means that if the MPDU
			length is shorter than 2596 bytes then additional zero
			length delimiter and MAC byte padding should be added to get
			to a combined byte count of 2596 bytes.  This does not
			include the non-zero length delimiter.

reserved_2b
			
			Generator should set to 0 and consumer will ignore. 
			<legal 0>

fixed_delim_padding_bw80
			
			A fixed number of zero-length delimiters to add after
			each MPDU.The actual number of zero-length delimiters will
			be maximum of this field and the amount based on the
			min_mpdu_spacing field.

pdg_more_data_control_enable
			
			PDG based more bit clearing enable
			
			
			
			0: No action
			
			1: When PDG is calculating the amount of frames that can
			be sent in the upcoming Frame Exchange Sequence, it will
			have to check if that amount is equal to the in field
			pdg_more_data_clear_threshold indicated number of frames.
			When this is NOT the case, PDG will signal TXP PCU to set
			the More Data bit in all of the frames transmitted.
			
			Note that this indication might be clear for the 80Mhz
			transmission, but for example set for the 20 Mhz
			transmission (which had less number of frames).
			
			<legal all>

pdg_more_data_set_threshold
			
			Field is only valid when pdg_more_data_control_enable is
			set.
			
			When pdg determines that less then this number of frames
			can be transmitted in the upcoming transmission, PDG will
			signal to the TX PCU that the More Data bit in the frames
			need to be set.
			
			It is up to sw to make sure that
			pdg_more_data_clear_threshold is always smaller or equal to
			the Max_mpdu_cnt.
			
			<legal all>

reserved_3a
			
			Generator should set to 0 and consumer will ignore. 
			<legal 0>

min_mpdu_spacing_bw80
			
			Minimum number of dwords in an MPDU.  If the actual MPDU
			size is smaller than this, the PCU will insert zero-length
			delimiters after this MPDU to compensate for the difference.
			For example at a PHY rate of 1.3 Gbps if the receiver is
			capable of receiving only 1 MPDU every 16 usec, then this
			field should be set to 649.  This means that if the MPDU
			length is shorter than 2596 bytes then additional zero
			length delimiter and MAC byte padding should be added to get
			to a combined byte count of 2596 bytes.  This does not
			include the non-zero length delimiter.

reserved_3b
			
			Generator should set to 0 and consumer will ignore. 
			<legal 0>

fixed_delim_padding_bw40
			
			A fixed number of zero-length delimiters to add after
			each MPDU.The actual number of zero-length delimiters will
			be maximum of this field and the amount based on the
			min_mpdu_spacing field.

struct tx_rate_setting tx_rate_ctr_ppdu_bw20
			
			Field only valid when ppdu_allowed_bw20 is set.
			
			Structure containing all the rate information for
			transmitting the PPDU at 20 MHz.

struct tx_rate_setting tx_rate_ctr_ppdu_bw40
			
			Field only valid when ppdu_allowed_bw40 is set.
			
			Structure containing all the rate information for
			transmitting the PPDU at 40 MHz.

struct tx_rate_setting tx_rate_ctr_ppdu_bw80
			
			Field only valid when ppdu_allowed_bw80 is set.
			
			Structure containing all the rate information for
			transmitting the PPDU at 80 MHz.

struct tx_rate_setting response_rate_bw20
			
			Field only valid when ppdu_allowed_bw20 is set.
			
			Structure containing all the rate information for
			transmitting the PPDU at 20 MHz.

struct tx_rate_setting response_rate_bw40
			
			Field only valid when ppdu_allowed_bw40 is set.
			
			Structure containing all the rate information for
			transmitting the PPDU at 40 MHz.

struct tx_rate_setting response_rate_bw80
			
			Field only valid when ppdu_allowed_bw80 is set.
			
			Structure containing all the rate information for
			transmitting the PPDU at 80 MHz.
*/


/* Description		PDG_SETUP_USERX_0_MAX_AMPDU_SIZE
			
			The maximum number of bytes in the PPDU transmission.
*/
#define PDG_SETUP_USERX_0_MAX_AMPDU_SIZE_OFFSET                      0x00000000
#define PDG_SETUP_USERX_0_MAX_AMPDU_SIZE_LSB                         0
#define PDG_SETUP_USERX_0_MAX_AMPDU_SIZE_MASK                        0x000fffff

/* Description		PDG_SETUP_USERX_0_PCU_DATA_THRESHOLD_20
			
			Field only valid for 20MHz BW transmissions
			
			The minimum amount of MPDU data present in the TX PCU
			buffer, before TX PCU allows this MPDU data to transfer to
			the PHY. This threshold prevents or reduces data underrun
			conditions during an MPDU transmission. 
			
			If an entire MPDU frame is present in the TX PCU buffer
			that is smaller than this threshold value, this threshold is
			ignored, and MPDU data transfer to the PHY is allowed to
			start.
			
			In units of 256 bytes.
			
			<legal all>
*/
#define PDG_SETUP_USERX_0_PCU_DATA_THRESHOLD_20_OFFSET               0x00000000
#define PDG_SETUP_USERX_0_PCU_DATA_THRESHOLD_20_LSB                  20
#define PDG_SETUP_USERX_0_PCU_DATA_THRESHOLD_20_MASK                 0x00f00000

/* Description		PDG_SETUP_USERX_0_PCU_DATA_THRESHOLD_40
			
			Field only valid for 40MHz BW transmissions
			
			The minimum amount of MPDU data present in the TX PCU
			buffer, before TX PCU allows this MPDU data to transfer to
			the PHY. This threshold prevents or reduces data underrun
			conditions during an MPDU transmission. 
			
			If an entire MPDU frame is present in the TX PCU buffer
			that is smaller than this threshold value, this threshold is
			ignored, and MPDU data transfer to the PHY is allowed to
			start.
			
			In units of 256 bytes.
			
			<legal all>
*/
#define PDG_SETUP_USERX_0_PCU_DATA_THRESHOLD_40_OFFSET               0x00000000
#define PDG_SETUP_USERX_0_PCU_DATA_THRESHOLD_40_LSB                  24
#define PDG_SETUP_USERX_0_PCU_DATA_THRESHOLD_40_MASK                 0x0f000000

/* Description		PDG_SETUP_USERX_0_PCU_DATA_THRESHOLD_80
			
			Field only valid for 80MHz BW transmissions
			
			The minimum amount of MPDU data present in the TX PCU
			buffer, before TX PCU allows this MPDU data to transfer to
			the PHY. This threshold prevents or reduces data underrun
			conditions during an MPDU transmission. 
			
			If an entire MPDU frame is present in the TX PCU buffer
			that is smaller than this threshold value, this threshold is
			ignored, and MPDU data transfer to the PHY is allowed to
			start.
			
			In units of 256 bytes.
			
			<legal all>
*/
#define PDG_SETUP_USERX_0_PCU_DATA_THRESHOLD_80_OFFSET               0x00000000
#define PDG_SETUP_USERX_0_PCU_DATA_THRESHOLD_80_LSB                  28
#define PDG_SETUP_USERX_0_PCU_DATA_THRESHOLD_80_MASK                 0xf0000000

/* Description		PDG_SETUP_USERX_1_MAX_MPDU_CNT
			
			The maximum number of MPDUs in the PPDU transmission.
			
			Note: This is different than A-MPDU window size given in
			the Queue extension descriptor. This field allows per
			scheduler command fine-tuning control.
*/
#define PDG_SETUP_USERX_1_MAX_MPDU_CNT_OFFSET                        0x00000004
#define PDG_SETUP_USERX_1_MAX_MPDU_CNT_LSB                           0
#define PDG_SETUP_USERX_1_MAX_MPDU_CNT_MASK                          0x0000007f

/* Description		PDG_SETUP_USERX_1_MU_USER_NUMBER
			
			Mapping from user number to mu_user_number.  This is the
			mapping of this user for the GID that is being used.<legal
			0-3>
*/
#define PDG_SETUP_USERX_1_MU_USER_NUMBER_OFFSET                      0x00000004
#define PDG_SETUP_USERX_1_MU_USER_NUMBER_LSB                         7
#define PDG_SETUP_USERX_1_MU_USER_NUMBER_MASK                        0x00000380

/* Description		PDG_SETUP_USERX_1_MIN_MPDU_SPACING_BW20
			
			Minimum number of dwords in an MPDU.  If the actual MPDU
			size is smaller than this, the PCU will insert zero-length
			delimiters after this MPDU to compensate for the difference.
			For example at a PHY rate of 1.3 Gbps if the receiver is
			capable of receiving only 1 MPDU every 16 usec, then this
			field should be set to 649.  This means that if the MPDU
			length is shorter than 2596 bytes then additional zero
			length delimiter and MAC byte padding should be added to get
			to a combined byte count of 2596 bytes.  This does not
			include the non-zero length delimiter.
*/
#define PDG_SETUP_USERX_1_MIN_MPDU_SPACING_BW20_OFFSET               0x00000004
#define PDG_SETUP_USERX_1_MIN_MPDU_SPACING_BW20_LSB                  10
#define PDG_SETUP_USERX_1_MIN_MPDU_SPACING_BW20_MASK                 0x000ffc00

/* Description		PDG_SETUP_USERX_1_STA_PWR_STATE
			
			The power state of the destination STA
			
			
			
			0: STA not in power save mode
			
			1: STA is in power save mode
			
			
			
			This setting is needed by PDG to determine if the
			This_queue_more_data bit in the PCU_PPDU_SETUP TLV needs to
			be set.
*/
#define PDG_SETUP_USERX_1_STA_PWR_STATE_OFFSET                       0x00000004
#define PDG_SETUP_USERX_1_STA_PWR_STATE_LSB                          20
#define PDG_SETUP_USERX_1_STA_PWR_STATE_MASK                         0x00100000

/* Description		PDG_SETUP_USERX_1_RESERVED_1
			
			Generator should set to 0 and consumer will ignore. 
			<legal 0>
*/
#define PDG_SETUP_USERX_1_RESERVED_1_OFFSET                          0x00000004
#define PDG_SETUP_USERX_1_RESERVED_1_LSB                             21
#define PDG_SETUP_USERX_1_RESERVED_1_MASK                            0x00e00000

/* Description		PDG_SETUP_USERX_1_FIXED_DELIM_PADDING_BW20
			
			A fixed number of zero-length delimiters to add after
			each MPDU.The actual number of zero-length delimiters will
			be maximum of this field and the amount based on the
			min_mpdu_spacing field.
*/
#define PDG_SETUP_USERX_1_FIXED_DELIM_PADDING_BW20_OFFSET            0x00000004
#define PDG_SETUP_USERX_1_FIXED_DELIM_PADDING_BW20_LSB               24
#define PDG_SETUP_USERX_1_FIXED_DELIM_PADDING_BW20_MASK              0xff000000

/* Description		PDG_SETUP_USERX_2_PDG_EOSP_CONTROL_ENABLE
			
			PDG based eosp bit assertion enabled
			
			
			
			0: No action
			
			1: When PDG is calculating the amount of frames that can
			be sent in the upcoming Frame Exchange Sequence, it will
			have to check if that amount is equal to the in field
			eosp_set_threshold indicated number of frames. When this is
			the case, PDG will signal TXP PCU to set the EOSP bit in all
			of those frames.
			
			Note that this indication might be set for the 80Mhz
			transmission, but for example not for the 20 Mhz
			transmission (which had less number of frames).
			
			<legal all>
*/
#define PDG_SETUP_USERX_2_PDG_EOSP_CONTROL_ENABLE_OFFSET             0x00000008
#define PDG_SETUP_USERX_2_PDG_EOSP_CONTROL_ENABLE_LSB                0
#define PDG_SETUP_USERX_2_PDG_EOSP_CONTROL_ENABLE_MASK               0x00000001

/* Description		PDG_SETUP_USERX_2_PDG_EOSP_SET_THRESHOLD
			
			
			When pdg determines that this number of frames can be
			transmitted in the upcoming transmission, PDG will signal to
			the TX PCU that the EOSP bit in the frames need to be set.
			
			It is up to sw to make sure that eosp_set_threshold is
			always equal or larger then Max_mpdu_cnt.
			
			<legal all>
*/
#define PDG_SETUP_USERX_2_PDG_EOSP_SET_THRESHOLD_OFFSET              0x00000008
#define PDG_SETUP_USERX_2_PDG_EOSP_SET_THRESHOLD_LSB                 1
#define PDG_SETUP_USERX_2_PDG_EOSP_SET_THRESHOLD_MASK                0x000000fe

/* Description		PDG_SETUP_USERX_2_RESERVED_2A
			
			Generator should set to 0 and consumer will ignore. 
			<legal 0>
*/
#define PDG_SETUP_USERX_2_RESERVED_2A_OFFSET                         0x00000008
#define PDG_SETUP_USERX_2_RESERVED_2A_LSB                            8
#define PDG_SETUP_USERX_2_RESERVED_2A_MASK                           0x00000300

/* Description		PDG_SETUP_USERX_2_MIN_MPDU_SPACING_BW40
			
			Minimum number of dwords in an MPDU.  If the actual MPDU
			size is smaller than this, the PCU will insert zero-length
			delimiters after this MPDU to compensate for the difference.
			For example at a PHY rate of 1.3 Gbps if the receiver is
			capable of receiving only 1 MPDU every 16 usec, then this
			field should be set to 649.  This means that if the MPDU
			length is shorter than 2596 bytes then additional zero
			length delimiter and MAC byte padding should be added to get
			to a combined byte count of 2596 bytes.  This does not
			include the non-zero length delimiter.
*/
#define PDG_SETUP_USERX_2_MIN_MPDU_SPACING_BW40_OFFSET               0x00000008
#define PDG_SETUP_USERX_2_MIN_MPDU_SPACING_BW40_LSB                  10
#define PDG_SETUP_USERX_2_MIN_MPDU_SPACING_BW40_MASK                 0x000ffc00

/* Description		PDG_SETUP_USERX_2_RESERVED_2B
			
			Generator should set to 0 and consumer will ignore. 
			<legal 0>
*/
#define PDG_SETUP_USERX_2_RESERVED_2B_OFFSET                         0x00000008
#define PDG_SETUP_USERX_2_RESERVED_2B_LSB                            20
#define PDG_SETUP_USERX_2_RESERVED_2B_MASK                           0x00f00000

/* Description		PDG_SETUP_USERX_2_FIXED_DELIM_PADDING_BW80
			
			A fixed number of zero-length delimiters to add after
			each MPDU.The actual number of zero-length delimiters will
			be maximum of this field and the amount based on the
			min_mpdu_spacing field.
*/
#define PDG_SETUP_USERX_2_FIXED_DELIM_PADDING_BW80_OFFSET            0x00000008
#define PDG_SETUP_USERX_2_FIXED_DELIM_PADDING_BW80_LSB               24
#define PDG_SETUP_USERX_2_FIXED_DELIM_PADDING_BW80_MASK              0xff000000

/* Description		PDG_SETUP_USERX_3_PDG_MORE_DATA_CONTROL_ENABLE
			
			PDG based more bit clearing enable
			
			
			
			0: No action
			
			1: When PDG is calculating the amount of frames that can
			be sent in the upcoming Frame Exchange Sequence, it will
			have to check if that amount is equal to the in field
			pdg_more_data_clear_threshold indicated number of frames.
			When this is NOT the case, PDG will signal TXP PCU to set
			the More Data bit in all of the frames transmitted.
			
			Note that this indication might be clear for the 80Mhz
			transmission, but for example set for the 20 Mhz
			transmission (which had less number of frames).
			
			<legal all>
*/
#define PDG_SETUP_USERX_3_PDG_MORE_DATA_CONTROL_ENABLE_OFFSET        0x0000000c
#define PDG_SETUP_USERX_3_PDG_MORE_DATA_CONTROL_ENABLE_LSB           0
#define PDG_SETUP_USERX_3_PDG_MORE_DATA_CONTROL_ENABLE_MASK          0x00000001

/* Description		PDG_SETUP_USERX_3_PDG_MORE_DATA_SET_THRESHOLD
			
			Field is only valid when pdg_more_data_control_enable is
			set.
			
			When pdg determines that less then this number of frames
			can be transmitted in the upcoming transmission, PDG will
			signal to the TX PCU that the More Data bit in the frames
			need to be set.
			
			It is up to sw to make sure that
			pdg_more_data_clear_threshold is always smaller or equal to
			the Max_mpdu_cnt.
			
			<legal all>
*/
#define PDG_SETUP_USERX_3_PDG_MORE_DATA_SET_THRESHOLD_OFFSET         0x0000000c
#define PDG_SETUP_USERX_3_PDG_MORE_DATA_SET_THRESHOLD_LSB            1
#define PDG_SETUP_USERX_3_PDG_MORE_DATA_SET_THRESHOLD_MASK           0x000000fe

/* Description		PDG_SETUP_USERX_3_RESERVED_3A
			
			Generator should set to 0 and consumer will ignore. 
			<legal 0>
*/
#define PDG_SETUP_USERX_3_RESERVED_3A_OFFSET                         0x0000000c
#define PDG_SETUP_USERX_3_RESERVED_3A_LSB                            8
#define PDG_SETUP_USERX_3_RESERVED_3A_MASK                           0x00000300

/* Description		PDG_SETUP_USERX_3_MIN_MPDU_SPACING_BW80
			
			Minimum number of dwords in an MPDU.  If the actual MPDU
			size is smaller than this, the PCU will insert zero-length
			delimiters after this MPDU to compensate for the difference.
			For example at a PHY rate of 1.3 Gbps if the receiver is
			capable of receiving only 1 MPDU every 16 usec, then this
			field should be set to 649.  This means that if the MPDU
			length is shorter than 2596 bytes then additional zero
			length delimiter and MAC byte padding should be added to get
			to a combined byte count of 2596 bytes.  This does not
			include the non-zero length delimiter.
*/
#define PDG_SETUP_USERX_3_MIN_MPDU_SPACING_BW80_OFFSET               0x0000000c
#define PDG_SETUP_USERX_3_MIN_MPDU_SPACING_BW80_LSB                  10
#define PDG_SETUP_USERX_3_MIN_MPDU_SPACING_BW80_MASK                 0x000ffc00

/* Description		PDG_SETUP_USERX_3_RESERVED_3B
			
			Generator should set to 0 and consumer will ignore. 
			<legal 0>
*/
#define PDG_SETUP_USERX_3_RESERVED_3B_OFFSET                         0x0000000c
#define PDG_SETUP_USERX_3_RESERVED_3B_LSB                            20
#define PDG_SETUP_USERX_3_RESERVED_3B_MASK                           0x00f00000

/* Description		PDG_SETUP_USERX_3_FIXED_DELIM_PADDING_BW40
			
			A fixed number of zero-length delimiters to add after
			each MPDU.The actual number of zero-length delimiters will
			be maximum of this field and the amount based on the
			min_mpdu_spacing field.
*/
#define PDG_SETUP_USERX_3_FIXED_DELIM_PADDING_BW40_OFFSET            0x0000000c
#define PDG_SETUP_USERX_3_FIXED_DELIM_PADDING_BW40_LSB               24
#define PDG_SETUP_USERX_3_FIXED_DELIM_PADDING_BW40_MASK              0xff000000
#define PDG_SETUP_USERX_4_TX_RATE_SETTING_TX_RATE_CTR_PPDU_BW20_OFFSET 0x00000010
#define PDG_SETUP_USERX_4_TX_RATE_SETTING_TX_RATE_CTR_PPDU_BW20_LSB  24
#define PDG_SETUP_USERX_4_TX_RATE_SETTING_TX_RATE_CTR_PPDU_BW20_MASK 0xffffffff
#define PDG_SETUP_USERX_5_TX_RATE_SETTING_TX_RATE_CTR_PPDU_BW20_OFFSET 0x00000014
#define PDG_SETUP_USERX_5_TX_RATE_SETTING_TX_RATE_CTR_PPDU_BW20_LSB  24
#define PDG_SETUP_USERX_5_TX_RATE_SETTING_TX_RATE_CTR_PPDU_BW20_MASK 0xffffffff
#define PDG_SETUP_USERX_6_TX_RATE_SETTING_TX_RATE_CTR_PPDU_BW40_OFFSET 0x00000018
#define PDG_SETUP_USERX_6_TX_RATE_SETTING_TX_RATE_CTR_PPDU_BW40_LSB  24
#define PDG_SETUP_USERX_6_TX_RATE_SETTING_TX_RATE_CTR_PPDU_BW40_MASK 0xffffffff
#define PDG_SETUP_USERX_7_TX_RATE_SETTING_TX_RATE_CTR_PPDU_BW40_OFFSET 0x0000001c
#define PDG_SETUP_USERX_7_TX_RATE_SETTING_TX_RATE_CTR_PPDU_BW40_LSB  24
#define PDG_SETUP_USERX_7_TX_RATE_SETTING_TX_RATE_CTR_PPDU_BW40_MASK 0xffffffff
#define PDG_SETUP_USERX_8_TX_RATE_SETTING_TX_RATE_CTR_PPDU_BW80_OFFSET 0x00000020
#define PDG_SETUP_USERX_8_TX_RATE_SETTING_TX_RATE_CTR_PPDU_BW80_LSB  24
#define PDG_SETUP_USERX_8_TX_RATE_SETTING_TX_RATE_CTR_PPDU_BW80_MASK 0xffffffff
#define PDG_SETUP_USERX_9_TX_RATE_SETTING_TX_RATE_CTR_PPDU_BW80_OFFSET 0x00000024
#define PDG_SETUP_USERX_9_TX_RATE_SETTING_TX_RATE_CTR_PPDU_BW80_LSB  24
#define PDG_SETUP_USERX_9_TX_RATE_SETTING_TX_RATE_CTR_PPDU_BW80_MASK 0xffffffff
#define PDG_SETUP_USERX_10_TX_RATE_SETTING_RESPONSE_RATE_BW20_OFFSET 0x00000028
#define PDG_SETUP_USERX_10_TX_RATE_SETTING_RESPONSE_RATE_BW20_LSB    24
#define PDG_SETUP_USERX_10_TX_RATE_SETTING_RESPONSE_RATE_BW20_MASK   0xffffffff
#define PDG_SETUP_USERX_11_TX_RATE_SETTING_RESPONSE_RATE_BW20_OFFSET 0x0000002c
#define PDG_SETUP_USERX_11_TX_RATE_SETTING_RESPONSE_RATE_BW20_LSB    24
#define PDG_SETUP_USERX_11_TX_RATE_SETTING_RESPONSE_RATE_BW20_MASK   0xffffffff
#define PDG_SETUP_USERX_12_TX_RATE_SETTING_RESPONSE_RATE_BW40_OFFSET 0x00000030
#define PDG_SETUP_USERX_12_TX_RATE_SETTING_RESPONSE_RATE_BW40_LSB    24
#define PDG_SETUP_USERX_12_TX_RATE_SETTING_RESPONSE_RATE_BW40_MASK   0xffffffff
#define PDG_SETUP_USERX_13_TX_RATE_SETTING_RESPONSE_RATE_BW40_OFFSET 0x00000034
#define PDG_SETUP_USERX_13_TX_RATE_SETTING_RESPONSE_RATE_BW40_LSB    24
#define PDG_SETUP_USERX_13_TX_RATE_SETTING_RESPONSE_RATE_BW40_MASK   0xffffffff
#define PDG_SETUP_USERX_14_TX_RATE_SETTING_RESPONSE_RATE_BW80_OFFSET 0x00000038
#define PDG_SETUP_USERX_14_TX_RATE_SETTING_RESPONSE_RATE_BW80_LSB    24
#define PDG_SETUP_USERX_14_TX_RATE_SETTING_RESPONSE_RATE_BW80_MASK   0xffffffff
#define PDG_SETUP_USERX_15_TX_RATE_SETTING_RESPONSE_RATE_BW80_OFFSET 0x0000003c
#define PDG_SETUP_USERX_15_TX_RATE_SETTING_RESPONSE_RATE_BW80_LSB    24
#define PDG_SETUP_USERX_15_TX_RATE_SETTING_RESPONSE_RATE_BW80_MASK   0xffffffff


#endif // _PDG_SETUP_USERX_H_
